/*
 * Decompiled with CFR 0.152.
 */
package tdm.lib;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.xml.namespace.QName;
import org.xml.sax.SAXException;

public abstract class XMLNode
implements Cloneable {
    protected int infoSize = 0;
    private QName qname;

    public XMLNode(QName qname) {
        this.qname = qname;
    }

    public XMLNode() {
    }

    public QName getQname() {
        return this.qname;
    }

    public int getInfoSize() {
        return this.infoSize;
    }

    public abstract boolean contentEquals(Object var1);

    public abstract int getContentHash();

    protected MessageDigest getMD() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            System.err.println("MD5 hash generation not supported -- aborting");
            System.exit(-1);
            return null;
        }
    }

    protected byte[] calculateHash(char[] data) {
        MessageDigest contentHash = this.getMD();
        contentHash.reset();
        for (int i = 0; i < data.length; ++i) {
            contentHash.update((byte)(data[i] & 0xFF));
            contentHash.update((byte)(data[i] >> 8));
        }
        return contentHash.digest();
    }

    protected byte[] calculateHash(String data) {
        MessageDigest contentHash = this.getMD();
        contentHash.reset();
        for (int i = 0; i < data.length(); ++i) {
            contentHash.update((byte)(data.charAt(i) & 0xFF));
            contentHash.update((byte)(data.charAt(i) >> 8));
        }
        return contentHash.digest();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException x) {
            return null;
        }
    }

    public static interface Merger {
        public XMLNode merge(XMLNode var1, XMLNode var2, XMLNode var3);
    }

    public static interface Externalizer {
        public void startNode(XMLNode var1) throws IOException, SAXException;

        public void endNode(XMLNode var1) throws IOException, SAXException;
    }
}

