/*
 * Decompiled with CFR 0.152.
 */
package tdm.lib;

import com.ctc.wstx.stax.WstxEventFactory;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.events.Attribute;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;
import tdm.lib.XMLNode;

public class XMLElementNode
extends XMLNode {
    private String name = null;
    private AttributesImpl attributes = null;
    private int nHashCode = -1;
    private byte[] attrHash = null;

    public XMLElementNode(String aname, Attributes attr) {
        super(new QName(aname));
        this.name = aname;
        this.attributes = new AttributesImpl(attr);
        this.rehash();
    }

    public XMLElementNode(String aname, List<Attribute> attrib) {
        super(new QName(aname));
        this.name = aname;
        this.attributes = new AttributesImpl();
        for (Attribute attribute : attrib) {
            String prefix = attribute.getName().getPrefix();
            String qname = prefix + (prefix.length() > 0 ? ":" : "") + attribute.getName().getLocalPart();
            this.attributes.addAttribute("", this.ds(attribute.getName().getLocalPart()), this.ds(prefix), "", this.ds(attribute.getValue()));
        }
        this.rehash();
    }

    private String ds(String input) {
        if (input == null || "null".equals(input)) {
            return "";
        }
        return input;
    }

    public void rehash() {
        this.nHashCode = this.name.hashCode();
        this.infoSize = 1;
        MessageDigest md = this.getMD();
        for (int i = 0; i < this.attributes.getLength(); ++i) {
            int vsize = this.attributes.getValue(i).length();
            this.infoSize += 2 + (vsize > 5 ? vsize - 5 : 1);
            md.update(this.calculateHash(this.attributes.getQName(i)));
            md.update(this.calculateHash(this.attributes.getValue(i)));
        }
        this.attrHash = md.digest();
    }

    public String getNamespaceURI() {
        return "";
    }

    public String getLocalName() {
        return "";
    }

    public String getQName() {
        return this.name;
    }

    public void setQName(String aName) {
        this.name = aName;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public Iterator<Attribute> getAttributesIterator(WstxEventFactory factory) {
        ArrayList<Attribute> list = new ArrayList<Attribute>(this.attributes.getLength());
        for (int i = 0; i < this.attributes.getLength(); ++i) {
            String localName = this.ds(this.attributes.getQName(i)).length() > 0 ? this.attributes.getQName(i) + ":" + this.attributes.getLocalName(i) : this.attributes.getLocalName(i);
            list.add(factory.createAttribute(this.ds(this.attributes.getQName(i)), "", localName, this.ds(this.attributes.getValue(i))));
        }
        return list.iterator();
    }

    public void setAttributes(Attributes atts) {
        this.attributes = new AttributesImpl(atts);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.name);
        sb.append(" {");
        if (this.attributes != null && this.attributes.getLength() > 0) {
            for (int i = 0; i < this.attributes.getLength(); ++i) {
                sb.append(' ');
                sb.append(this.attributes.getQName(i));
                sb.append('=');
                sb.append(this.attributes.getValue(i));
            }
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean contentEquals(Object a) {
        if (a instanceof XMLElementNode) {
            return ((XMLElementNode)a).nHashCode == this.nHashCode && MessageDigest.isEqual(((XMLElementNode)a).attrHash, this.attrHash);
        }
        return false;
    }

    @Override
    public int getContentHash() {
        return this.attrHash[0] + (this.attrHash[1] << 8) + (this.attrHash[2] << 16) + (this.attrHash[3] << 24) ^ this.nHashCode;
    }

    @Override
    public Object clone() {
        XMLElementNode clone = (XMLElementNode)super.clone();
        clone.attributes = new AttributesImpl(this.attributes);
        return clone;
    }
}

