/*
 * Decompiled with CFR 0.152.
 */
package tdm.lib;

import java.util.Stack;
import java.util.Vector;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import tdm.lib.BaseNode;
import tdm.lib.BranchNode;
import tdm.lib.Node;
import tdm.lib.PathTracker;

public class EditLog {
    private static final int INSERT = 0;
    private static final int UPDATE = 1;
    private static final int COPY = 2;
    private static final int MOVE = 3;
    private static final int DELETE = 4;
    private static final String[] OPTAGS = new String[]{"insert", "update", "copy", "move", "delete"};
    private Stack checkPoints = new Stack();
    private Vector edits = new Vector();
    private PathTracker pt = null;

    public EditLog() {
    }

    public EditLog(PathTracker apt) {
        this.pt = apt;
    }

    public void insert(BranchNode n, int childPos) {
        this.edits.add(new EditEntry(0, null, n, this.pt.getPathString(childPos)));
    }

    public void insert(BranchNode n) {
        this.edits.add(new EditEntry(0, null, n, n));
    }

    public void move(BranchNode n, int childPos) {
        this.edits.add(new EditEntry(3, n.getBaseMatch(), n, this.pt.getPathString(childPos)));
    }

    public void move(BranchNode n) {
        this.edits.add(new EditEntry(3, n.getBaseMatch(), n, n));
    }

    public void copy(BranchNode n, int childPos) {
        this.edits.add(new EditEntry(2, n.getBaseMatch(), n, this.pt.getPathString(childPos)));
    }

    public void copy(BranchNode n) {
        this.edits.add(new EditEntry(2, n.getBaseMatch(), n, n));
    }

    public void update(BranchNode n) {
        if (this.pt == null) {
            this.edits.add(new EditEntry(1, n.getBaseMatch(), n, n));
        } else {
            this.edits.add(new EditEntry(1, n.getBaseMatch(), n, this.pt.getFullPathString()));
        }
    }

    public void delete(BaseNode n, BranchNode originatingList) {
        this.edits.add(new EditEntry(4, n, originatingList, ""));
    }

    public void writeEdits(ContentHandler ch) throws SAXException {
        ch.startDocument();
        AttributesImpl atts = new AttributesImpl();
        ch.startElement("", "", "edits", atts);
        for (int i = 0; i < this.edits.size(); ++i) {
            this.outputEdit((EditEntry)this.edits.elementAt(i), ch);
        }
        ch.endElement("", "", "edits");
        ch.endDocument();
    }

    protected void outputEdit(EditEntry ee, ContentHandler ch) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        if (ee.type != 4) {
            atts.addAttribute("", "", "path", "CDATA", ee.dstPath.toString());
        }
        if (ee.type != 0) {
            atts.addAttribute("", "", "src", "CDATA", PathTracker.getPathString(ee.baseSrc));
        }
        atts.addAttribute("", "", "originTree", "CDATA", ee.branchSrc.isLeftTree() ? "branch1" : "branch2");
        atts.addAttribute("", "", ee.type != 4 ? "originNode" : "originList", "CDATA", PathTracker.getPathString(ee.branchSrc));
        ch.startElement("", "", OPTAGS[ee.type], atts);
        ch.endElement("", "", OPTAGS[ee.type]);
    }

    public void checkPoint() {
        this.checkPoints.push(new Integer(this.edits.size()));
    }

    public void rewind() {
        int firstFree = (Integer)this.checkPoints.pop();
        this.edits.setSize(firstFree);
    }

    public void commit() {
        this.checkPoints.pop();
    }

    private class EditEntry {
        int type = -1;
        BaseNode baseSrc = null;
        BranchNode branchSrc = null;
        Path dstPath = null;

        EditEntry(int aType, BaseNode aBaseNode, BranchNode aBranchNode, String aDstPath) {
            this.type = aType;
            this.baseSrc = aBaseNode;
            this.branchSrc = aBranchNode;
            this.dstPath = new Path(aDstPath);
        }

        EditEntry(int aType, BaseNode aBaseNode, BranchNode aBranchNode, Node aDstNode) {
            this.type = aType;
            this.baseSrc = aBaseNode;
            this.branchSrc = aBranchNode;
            this.dstPath = new Path(aDstNode);
        }
    }

    private static class Path {
        String path = null;
        Node n = null;

        public Path(String aPath) {
            this.path = aPath;
        }

        public Path(Node aNode) {
            this.n = aNode;
        }

        public String toString() {
            if (this.path != null) {
                return this.path;
            }
            return PathTracker.getPathString(this.n);
        }
    }
}

