/**
 * @module confluence/aui-tooltip
 */
define('confluence/aui-tooltip', [
    'window',
    'document',
    'ajs',
    'jquery',
], function(
    window,
    document,
    AJS,
    $
) {
    'use strict';

    function invokeTooltip() {
        // data-aui-tooltip attribute should only be added to elements that have title attribute and needs to convert to aui tooltip
        // it has nothing to do with the normal function of the tooltip
        $('[data-aui-tooltip]').tooltip();
        // now that we have converted native tooltip to aui tooltip, lets remove the attribute, so we don't call tooltip function twice on the same element
        $('[data-aui-tooltip]').removeAttr('data-aui-tooltip');
    }

    // if the document is still loading start listening to the event
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', function() {
            invokeTooltip();
        });
    } else {
        // seems that the DOMContentLoaded event was fired before we got here to just convert the tooltip to aui tooltip
        invokeTooltip();
    }

    // the return here is only to enable the unit tests for this module otherwise this is not required
    return {
        invokeTooltip: invokeTooltip
    };
});

require('confluence/module-exporter').safeRequire('confluence/aui-tooltip');
