/**
 * @module confluence/aui-select
 */
define('confluence/aui-select', [
    'window',
    'document',
    'ajs',
    'jquery',
], function(
    window,
    document,
    AJS,
    $
) {
    'use strict';

    function invokeSelect2() {
        // data-aui-select-2 attribute should only be added to select elements that need to be converted to aui select2.
        // it has nothing to do with the normal function of the select
        $('select[data-aui-select-2]').auiSelect2({ minimumResultsForSearch: -1 });
        // now that we have converted native select to aui select2, lets remove the attribute, so we don't call auiSelect2 twice on the same element
        $('select[data-aui-select-2]').removeAttr('data-aui-select-2');
    }

    // if the document is still loading start listening to the event
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', function() {
            invokeSelect2();
        });
    } else {
        // seems that the DOMContentLoaded event was fired before we got here to just convert the tooltip to aui select2
        invokeSelect2();
    }

    // the return here is only to enable the unit tests for this module otherwise this is not required
    return {
        invokeSelect2: invokeSelect2,
    };
});

require('confluence/module-exporter').safeRequire('confluence/aui-select');
