/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.velocity;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.errorprone.annotations.Immutable;
import io.atlassian.util.concurrent.Lazy;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.velocity.context.Context;

@Immutable
final class ContextMapView
extends AbstractMap<String, Object> {
    private final Context context;
    private final Supplier<Set<Map.Entry<String, Object>>> entries;

    ContextMapView(Context context) {
        this.context = Objects.requireNonNull(context, "context");
        this.entries = Lazy.supplier(() -> ImmutableSet.copyOf((Collection)Lists.transform(Arrays.asList(context.getKeys()), (Function)new EntryTransformer())));
    }

    @Override
    public Object get(Object key) {
        return this.context.get((String)key);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.context.containsKey(key);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.entries.get();
    }

    class EntryTransformer
    implements Function<Object, Map.Entry<String, Object>> {
        EntryTransformer() {
        }

        public Map.Entry<String, Object> apply(Object key) {
            return new EntryView(key);
        }
    }

    @Immutable
    class EntryView
    implements Map.Entry<String, Object> {
        private final String key;

        EntryView(Object key) {
            this.key = (String)key;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return ContextMapView.this.context.get(this.key);
        }

        @Override
        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }
    }
}

