/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util.collections;

import com.atlassian.confluence.util.collections.MapBackedEntry;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;

class MapBackedEntrySet<K, V>
extends AbstractSet<Map.Entry<K, V>> {
    private final Map<K, V> map;

    MapBackedEntrySet(Map<K, V> map) {
        this.map = map;
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return new Iterator<Map.Entry<K, V>>(){
            private final Iterator<K> keyIterator;
            {
                this.keyIterator = MapBackedEntrySet.this.map.keySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.keyIterator.hasNext();
            }

            @Override
            public Map.Entry<K, V> next() {
                Object key = this.keyIterator.next();
                return new MapBackedEntry(key, MapBackedEntrySet.this.map);
            }

            @Override
            public void remove() {
                this.keyIterator.remove();
            }
        };
    }

    @Override
    public int size() {
        return this.map.size();
    }
}

