/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import org.apache.commons.lang.StringUtils;

public class VersionNumberComparator
implements Comparator<String> {
    @Override
    public int compare(String o1, String o2) {
        int i;
        if (Objects.equal((Object)o1, (Object)o2)) {
            return 0;
        }
        if (o1 == null && o2 != null) {
            return 1;
        }
        if (o1 != null && o2 == null) {
            return -1;
        }
        Integer[] version1 = this.splitVersion(o1);
        Integer[] version2 = this.splitVersion(o2);
        int commonSize = Math.min(version1.length, version2.length);
        for (i = 0; i < commonSize; ++i) {
            int compare = version1[i].compareTo(version2[i]);
            if (compare == 0) continue;
            return compare;
        }
        if (version1.length > commonSize) {
            for (i = commonSize; i < version1.length; ++i) {
                if (version1[i] == 0) continue;
                return 1;
            }
        }
        if (version2.length > commonSize) {
            for (i = commonSize; i < version2.length; ++i) {
                if (version2[i] == 0) continue;
                return -1;
            }
        }
        return 0;
    }

    private Integer[] splitVersion(String versionString) {
        if (StringUtils.isBlank((String)versionString)) {
            return new Integer[0];
        }
        ArrayList version = Lists.newArrayList();
        for (String part : versionString.split("\\.")) {
            String number = part.split("[^0-9]")[0];
            if (number.length() <= 0) continue;
            try {
                version.add(Integer.parseInt(number));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return version.toArray(new Integer[version.size()]);
    }
}

