/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.upgrade.AmpsOverridesManager;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.Event;
import com.atlassian.spring.container.ContainerManager;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmpsOverridesServletContextListener
implements ServletContextListener {
    private static final Logger log = LoggerFactory.getLogger(AmpsOverridesServletContextListener.class);

    public void contextInitialized(ServletContextEvent event) {
        log.debug("contextInitialized called");
        JohnsonEventContainer johnsonEvent = JohnsonEventContainer.get((ServletContext)event.getServletContext());
        if (BootstrapUtils.getBootstrapManager() == null) {
            log.warn("Overrides not attempted due to bootstrap errors");
            return;
        }
        if (!BootstrapUtils.getBootstrapManager().isSetupComplete()) {
            log.debug("Overrides not needed as server has not been set up yet");
            return;
        }
        if (!ContainerManager.isContainerSetup()) {
            log.warn("Overrides not attempted due to error in main spring context");
            return;
        }
        if (this.hasStartupError(johnsonEvent)) {
            log.debug("Overrides not attempted as Confluence cannot start up");
            return;
        }
        AmpsOverridesManager ampsOverridesManager = (AmpsOverridesManager)ContainerManager.getComponent((String)"ampsOverridesManager");
        ampsOverridesManager.doOverride();
        log.debug("contextInitialized completed successfully");
    }

    private boolean hasStartupError(JohnsonEventContainer johnsonEvent) {
        return this.hasError(johnsonEvent, "startup");
    }

    private boolean hasError(JohnsonEventContainer johnsonEvent, String errorType) {
        if (johnsonEvent.hasEvents()) {
            for (Object o : johnsonEvent.getEvents()) {
                Event e = (Event)o;
                if (!errorType.equals(e.getKey().getType())) continue;
                return true;
            }
        }
        return false;
    }

    public void contextDestroyed(ServletContextEvent event) {
    }
}

