/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.upgrade.UpgradeError;
import com.atlassian.confluence.upgrade.UpgradeException;
import com.atlassian.confluence.upgrade.UpgradeManager;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.Event;
import com.atlassian.spring.container.ContainerManager;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeLauncherServletContextListener
implements ServletContextListener {
    private static final Logger log = LoggerFactory.getLogger(UpgradeLauncherServletContextListener.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextInitialized(ServletContextEvent event) {
        block10: {
            log.debug("UpgradeLauncherServletContextListener contextInitialized called");
            JohnsonEventContainer johnsonEvent = JohnsonEventContainer.get((ServletContext)event.getServletContext());
            if (BootstrapUtils.getBootstrapManager() == null) {
                log.warn("Upgrades not attempted due to bootstrap errors");
                return;
            }
            if (!BootstrapUtils.getBootstrapManager().isSetupComplete()) {
                log.debug("Upgrades not needed as server has not been set up yet");
                return;
            }
            if (this.hasLicenseError(johnsonEvent)) {
                log.debug("Upgrades not attempted due to expired license");
                return;
            }
            if (!ContainerManager.isContainerSetup()) {
                log.warn("Upgrades not attempted due to error in main spring context");
                return;
            }
            UpgradeManager upgradeManager = (UpgradeManager)ContainerManager.getComponent((String)"upgradeManager");
            try {
                upgradeManager.upgrade(johnsonEvent);
            }
            catch (UpgradeException e) {
                log.error("Upgrade failed, application will not start: " + e.getMessage(), (Throwable)((Object)e));
            }
            finally {
                List<UpgradeError> errors = upgradeManager.getErrors();
                if (errors == null || errors.isEmpty()) break block10;
                log.error("{} errors were encountered during upgrade:", (Object)errors.size());
                int i = 1;
                for (UpgradeError message : errors) {
                    log.error("{}: {}", (Object)i++, (Object)message.getMessage());
                }
            }
        }
        log.debug("UpgradeLauncherServletContextListener contextInitialized completed successfully");
    }

    private boolean hasLicenseError(JohnsonEventContainer johnsonEvent) {
        if (johnsonEvent.hasEvents()) {
            for (Object o : johnsonEvent.getEvents()) {
                Event e = (Event)o;
                if (!"license-inconsistency".equals(e.getKey().getType())) continue;
                return true;
            }
        }
        return false;
    }

    public void contextDestroyed(ServletContextEvent event) {
    }
}

