/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.opensymphony.util.TextUtils;
import java.util.Comparator;

public class BuildNumComparator
implements Comparator<String> {
    @Override
    public int compare(String o1, String o2) {
        Double number1 = this.getBuildNumber(o1);
        Double number2 = this.getBuildNumber(o2);
        if (number1 == null && number2 == null) {
            return 0;
        }
        if (number1 == null) {
            return 1;
        }
        if (number2 == null) {
            return -1;
        }
        return number1.compareTo(number2);
    }

    private Double getBuildNumber(String versionString) {
        String buildNumber;
        if (versionString == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(versionString.length());
        boolean decSeen = false;
        for (int i = 0; i < versionString.toCharArray().length; ++i) {
            char c = versionString.toCharArray()[i];
            if (Character.isDigit(c)) {
                sb.append(c);
                continue;
            }
            if (c != '.') break;
            if (!decSeen) {
                decSeen = true;
                sb.append('.');
                continue;
            }
            sb.append('0');
        }
        if (!TextUtils.stringSet((String)(buildNumber = sb.toString()))) {
            return null;
        }
        return Double.valueOf(buildNumber);
    }
}

