/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate.support;

import com.atlassian.hibernate.adapter.adapters.HibernateExceptionAdapter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.util.EqualsHelper;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.usertype.UserType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.support.lob.LobCreator;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.orm.hibernate.support.AbstractLobType;

public class BlobInputStreamType
extends AbstractLobType
implements UserType {
    private static final Logger log = LoggerFactory.getLogger(BlobInputStreamType.class);

    protected Object nullSafeGetInternal(ResultSet rs, int index, LobHandler lobHandler) throws SQLException, IOException, HibernateException {
        log.debug("LobHandler: " + lobHandler);
        return lobHandler.getBlobAsBinaryStream(rs, index);
    }

    protected void nullSafeSetInternal(PreparedStatement ps, int index, Object value, LobCreator lobCreator) throws SQLException, IOException, HibernateException {
        log.debug("LobCreator: " + lobCreator);
        InputStream is = (InputStream)value;
        lobCreator.setBlobAsBinaryStream(ps, index, is, is == null ? 0 : is.available());
    }

    public int[] sqlTypes() {
        return new int[]{2004};
    }

    public Class returnedClass() {
        return InputStream.class;
    }

    public boolean equals(Object x, Object y) {
        return EqualsHelper.equals((Object)x, (Object)y);
    }

    public Object deepCopy(Object value) {
        return value;
    }

    public int hashCode(Object x) throws org.hibernate.HibernateException {
        return x != null ? x.hashCode() : 0;
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SharedSessionContractImplementor session, Object owner) throws org.hibernate.HibernateException, SQLException {
        try {
            return this.nullSafeGet(rs, names, owner);
        }
        catch (HibernateException ex) {
            throw HibernateExceptionAdapter.adapt((HibernateException)ex);
        }
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SharedSessionContractImplementor session) throws org.hibernate.HibernateException, SQLException {
        try {
            this.nullSafeSet(st, value, index);
        }
        catch (HibernateException ex) {
            throw HibernateExceptionAdapter.adapt((HibernateException)ex);
        }
    }

    public Serializable disassemble(Object value) throws org.hibernate.HibernateException {
        return value != null ? (Serializable)this.deepCopy(value) : null;
    }

    public Object assemble(Serializable cached, Object owner) throws org.hibernate.HibernateException {
        return cached != null ? this.deepCopy(cached) : null;
    }

    public Object replace(Object original, Object target, Object owner) throws org.hibernate.HibernateException {
        return original;
    }
}

