/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.serialization;

import com.atlassian.confluence.rest.serialization.Dates;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.TimeZone;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.ser.std.SerializerBase;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public final class OffsetDateTimeSerializer
extends SerializerBase<OffsetDateTime> {
    private final Style style;

    private OffsetDateTimeSerializer(Style style) {
        super(OffsetDateTime.class);
        this.style = style;
    }

    public static OffsetDateTimeSerializer serializeAsIso() {
        return new OffsetDateTimeSerializer(Style.ISO);
    }

    public static OffsetDateTimeSerializer serializeAsTimestamp() {
        return new OffsetDateTimeSerializer(Style.TIMESTAMP);
    }

    public void serialize(OffsetDateTime value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if (this.style == Style.TIMESTAMP) {
            jgen.writeNumber(value.toInstant().toEpochMilli());
        } else {
            jgen.writeString(this.adaptJodaDate(value));
        }
    }

    private String adaptJodaDate(OffsetDateTime value) {
        DateTime jodaDateTime = this.convertToJodaDateTime(value);
        return Dates.asTimeString(jodaDateTime);
    }

    private DateTime convertToJodaDateTime(OffsetDateTime dateTime) {
        return dateTime == null ? null : new DateTime(dateTime.toInstant().toEpochMilli(), DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone(dateTime.getOffset())));
    }

    private static enum Style {
        TIMESTAMP,
        ISO;

    }
}

