/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.serialization.jackson2;

import com.atlassian.confluence.api.model.content.Space;
import com.atlassian.confluence.api.model.link.Link;
import com.atlassian.confluence.api.model.link.LinkType;
import com.atlassian.confluence.api.model.reference.ModelMapBuilder;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import java.io.IOException;
import java.lang.reflect.Field;

public class SpaceDeserializer
extends JsonDeserializer<Space>
implements ResolvableDeserializer {
    private final JsonDeserializer<?> defaultDeserializer;
    private final JsonFactory jsonFactory;

    public SpaceDeserializer(JsonDeserializer<?> defaultDeserializer) {
        this.defaultDeserializer = defaultDeserializer;
        this.jsonFactory = new JsonFactory();
    }

    public Space deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)jp.readValueAsTree();
        try (JsonParser parser = this.jsonFactory.createParser(node.toString());){
            parser.setCodec(jp.getCodec());
            parser.nextToken();
            Space space = (Space)this.defaultDeserializer.deserialize(parser, ctxt);
            if (node.has("_links") || node.has("links")) {
                this.deserializeLinks(node, space);
            }
            Space space2 = space;
            return space2;
        }
    }

    private void deserializeLinks(JsonNode node, Space space) throws IOException {
        JsonNode linkNode = node.has("_links") ? node.get("_links") : node.get("links");
        ModelMapBuilder mapBuilder = ModelMapBuilder.newInstance();
        LinkType.BUILT_IN.stream().filter(linkType -> linkNode.has(linkType.serialise())).forEach(linkType -> {
            String linkPath = linkNode.get(linkType.serialise()).asText();
            mapBuilder.put(linkType, (Object)new Link(linkType, linkPath));
        });
        SpaceDeserializer.setFieldValue(space, "links", mapBuilder.build());
    }

    private static void setFieldValue(Space space, String fieldName, Object value) throws IOException {
        try {
            Field field = Space.class.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(space, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IOException(e);
        }
    }

    public void resolve(DeserializationContext deserializationContext) throws JsonMappingException {
        ((ResolvableDeserializer)this.defaultDeserializer).resolve(deserializationContext);
    }
}

