/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.serialization.jackson2;

import com.atlassian.confluence.api.model.reference.Reference;
import com.atlassian.confluence.rest.v2.api.model.RestEntity;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class RestEntitySerializer
extends StdSerializer<RestEntity> {
    protected RestEntitySerializer() {
        super(RestEntity.class, false);
    }

    public void serializeWithType(RestEntity value, JsonGenerator jsonGen, SerializerProvider serializerProvider, TypeSerializer typeSer) throws IOException {
        this.serialize(value, jsonGen, serializerProvider);
    }

    public void serialize(RestEntity entity, JsonGenerator jsonGen, SerializerProvider serializerProvider) throws IOException {
        Supplier properties = Suppliers.memoize(() -> this.getDelegateBeanPropertyDefinitions(entity, serializerProvider));
        jsonGen.writeStartObject();
        for (Map.Entry prop : entity.properties().entrySet()) {
            Object value = prop.getValue();
            if (value instanceof Reference && !((Reference)value).isExpanded()) continue;
            if (value instanceof Collection) {
                if (this.hasDelegateBeanProperty((String)prop.getKey(), (List)properties.get())) {
                    this.writeDelegateField(jsonGen, serializerProvider, (String)prop.getKey(), value, (List)properties.get());
                    continue;
                }
                jsonGen.writeObjectField((String)prop.getKey(), value);
                continue;
            }
            jsonGen.writeObjectField((String)prop.getKey(), value);
        }
        jsonGen.writeEndObject();
        jsonGen.flush();
    }

    private void writeDelegateField(JsonGenerator jsonGen, SerializerProvider serializerProvider, String fieldName, Object value, List<BeanPropertyDefinition> properties) throws IOException {
        BeanProperty property = this.getDelegateBeanProperty(serializerProvider, fieldName, properties);
        jsonGen.writeFieldName(fieldName);
        JsonSerializer serializer = serializerProvider.findTypedValueSerializer(property != null ? property.getType() : null, true, property);
        serializer.serialize(value, jsonGen, serializerProvider);
    }

    private List<BeanPropertyDefinition> getDelegateBeanPropertyDefinitions(RestEntity entity, SerializerProvider serializerProvider) {
        JavaType javaType = serializerProvider.constructType(entity.getDelegate().getClass());
        BeanDescription beanDescription = serializerProvider.getConfig().introspect(javaType);
        return beanDescription.findProperties();
    }

    private boolean hasDelegateBeanProperty(String fieldName, List<BeanPropertyDefinition> properties) {
        for (BeanPropertyDefinition property : properties) {
            AnnotatedField field = property.getField();
            if (!property.hasField() || !fieldName.equals(field.getName())) continue;
            return true;
        }
        return false;
    }

    private BeanProperty getDelegateBeanProperty(SerializerProvider serializerProvider, String fieldName, List<BeanPropertyDefinition> properties) {
        for (BeanPropertyDefinition property : properties) {
            AnnotatedField field = property.getField();
            if (!property.hasField() || !fieldName.equals(field.getName())) continue;
            JavaType fieldJavaType = serializerProvider.constructType((Type)field.getType());
            return new BeanProperty.Std(property.getFullName(), fieldJavaType, property.getWrapperName(), (AnnotatedMember)field, property.getMetadata());
        }
        return null;
    }
}

