/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.serialization.jackson2;

import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.link.Link;
import com.atlassian.confluence.api.model.link.LinkType;
import com.atlassian.confluence.api.model.reference.ModelMapBuilder;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import java.io.IOException;
import java.lang.reflect.Field;

public class ContentDeserializer
extends JsonDeserializer<Content>
implements ResolvableDeserializer {
    private final JsonDeserializer<?> defaultDeserializer;
    private final JsonFactory jsonFactory;

    public ContentDeserializer(JsonDeserializer<?> defaultDeserializer) {
        this.defaultDeserializer = defaultDeserializer;
        this.jsonFactory = new JsonFactory();
    }

    public Content deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode node = (JsonNode)jsonParser.readValueAsTree();
        try (JsonParser parser = this.jsonFactory.createParser(node.toString());){
            parser.setCodec(jsonParser.getCodec());
            parser.nextToken();
            Content content = (Content)this.defaultDeserializer.deserialize(parser, deserializationContext);
            if (node.has("_links") || node.has("links")) {
                this.deserializeLinks(node, content);
            }
            Content content2 = content;
            return content2;
        }
    }

    public void resolve(DeserializationContext deserializationContext) throws JsonMappingException {
        ((ResolvableDeserializer)this.defaultDeserializer).resolve(deserializationContext);
    }

    private void deserializeLinks(JsonNode node, Content content) throws IOException {
        JsonNode linkNode = node.has("_links") ? node.get("_links") : node.get("links");
        ModelMapBuilder mapBuilder = ModelMapBuilder.newInstance();
        LinkType.BUILT_IN.stream().filter(linkType -> linkNode.has(linkType.serialise())).forEach(linkType -> {
            String linkPath = linkNode.get(linkType.serialise()).asText();
            mapBuilder.put(linkType, (Object)new Link(linkType, linkPath));
        });
        ContentDeserializer.setFieldValue(content, "links", mapBuilder.build());
    }

    private static void setFieldValue(Content content, String fieldName, Object value) throws IOException {
        try {
            Field field = Content.class.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(content, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IOException(e);
        }
    }
}

