/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.JsonContentProperty;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.content.id.JsonContentPropertyId;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.reference.Reference;
import com.atlassian.confluence.api.service.content.ContentPropertyService;
import com.atlassian.confluence.rest.client.AbstractRemoteService;
import com.atlassian.confluence.rest.client.RemoteContentPropertyService;
import com.atlassian.confluence.rest.client.authentication.AuthenticatedWebResourceProvider;
import com.sun.jersey.api.client.WebResource;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;

public class RemoteContentPropertyServiceImpl
extends AbstractRemoteService<ContentPropertyService>
implements RemoteContentPropertyService {
    private static final String NOT_IMPLEMENTED = "Not implemented";

    public RemoteContentPropertyServiceImpl(AuthenticatedWebResourceProvider provider, ExecutorService executor) {
        super(provider, executor);
    }

    @Override
    public RemoteContentPropertyService.RemoteContentPropertyFinder find(Expansion ... expansions) {
        return new RemoteContentPropertyFinderImpl(this, expansions);
    }

    @Override
    public CompletionStage<JsonContentProperty> createCompletionStage(JsonContentProperty newProperty) {
        WebResource resource = this.getContentPropertyWebResource(newProperty);
        return this.postCompletionStage(resource, JsonContentProperty.class, newProperty);
    }

    @Override
    public CompletionStage<JsonContentProperty> updateCompletionStage(JsonContentProperty property) {
        WebResource resource = this.getContentPropertyWebResource(property).path(property.getKey());
        return this.putCompletionStage(resource, JsonContentProperty.class, property);
    }

    @Override
    public CompletionStage<Void> deleteCompletionStage(JsonContentProperty property) {
        WebResource resource = this.getContentPropertyWebResource(property).path(property.getKey());
        return this.deleteCompletionStage(resource);
    }

    @Override
    public RemoteContentPropertyService.RemoteValidator validator() {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED);
    }

    private WebResource getContentPropertyWebResource(JsonContentProperty property) {
        return this.getContentPropertyWebResource(this.getContentId(property));
    }

    private WebResource getContentPropertyWebResource(ContentId contentId) {
        return this.newRestWebResource().path("content").path(contentId.serialise()).path("property");
    }

    private ContentId getContentId(JsonContentProperty property) {
        return Content.getSelector((Reference)property.getContentRef()).getId();
    }

    public class RemoteContentPropertyFinderImpl
    extends AbstractRemoteService<ContentPropertyService.ContentPropertyFinder>
    implements RemoteContentPropertyService.RemoteContentPropertyFinder {
        private final Expansion[] expansions;
        private ContentId contentId;
        private JsonContentPropertyId contentPropertyId;
        private String key;

        public RemoteContentPropertyFinderImpl(AbstractRemoteService<ContentPropertyService> other, Expansion ... expansions) {
            super(other);
            this.expansions = expansions;
        }

        @Override
        public RemoteContentPropertyService.RemoteSingleContentPropertyFetcher withId(JsonContentPropertyId contentPropertyId) {
            this.contentPropertyId = contentPropertyId;
            return this;
        }

        @Override
        public RemoteContentPropertyService.RemoteParameterContentPropertyFinder withContentId(ContentId contentId) {
            this.contentId = contentId;
            return this;
        }

        @Override
        public RemoteContentPropertyService.RemoteParameterContentPropertyFinder withContentIds(List<ContentId> contentIds) {
            throw new UnsupportedOperationException(RemoteContentPropertyServiceImpl.NOT_IMPLEMENTED);
        }

        @Override
        public RemoteContentPropertyService.RemoteParameterContentPropertyFinder withPropertyKeys(List<String> keys) {
            throw new UnsupportedOperationException(RemoteContentPropertyServiceImpl.NOT_IMPLEMENTED);
        }

        @Override
        public RemoteContentPropertyService.RemoteParameterContentPropertyFinder withKey(String key) {
            return this.withPropertyKey(key);
        }

        @Override
        public RemoteContentPropertyService.RemoteParameterContentPropertyFinder withPropertyKey(String key) {
            this.key = key;
            return this;
        }

        @Override
        public CompletionStage<PageResponse<JsonContentProperty>> fetchManyCompletionStage(PageRequest request) {
            WebResource resource = RemoteContentPropertyServiceImpl.this.getContentPropertyWebResource(this.contentId);
            resource = this.addExpansions(resource, this.expansions);
            resource = this.addPageRequest(resource, request);
            return this.getCompletionStagePageResponseList(resource, JsonContentProperty.class);
        }

        @Override
        public CompletionStage<Optional<JsonContentProperty>> fetchCompletionStage() {
            if (this.contentPropertyId != null) {
                throw new UnsupportedOperationException("remote fetch with contentPropertyId is not supported");
            }
            Objects.requireNonNull(this.contentId, "ContentId is required to locate content properties");
            WebResource resource = RemoteContentPropertyServiceImpl.this.getContentPropertyWebResource(this.contentId);
            if (this.key != null) {
                resource = resource.path(this.key);
            }
            resource = this.addExpansions(resource, this.expansions);
            return this.getCompletionStageOptional(resource, JsonContentProperty.class);
        }
    }
}

