/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.search.SearchPageResponse;
import com.atlassian.confluence.api.service.exceptions.NotFoundException;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.rest.api.model.ExpansionsParser;
import com.atlassian.confluence.rest.api.model.RestList;
import com.atlassian.confluence.rest.client.authentication.AuthenticatedWebResourceProvider;
import com.atlassian.confluence.rest.client.model.ExceptionConverter;
import com.atlassian.confluence.rest.client.util.MediaTypeUtils;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javax.ws.rs.core.MediaType;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRemoteService<P> {
    private static final Logger log = LoggerFactory.getLogger(AbstractRemoteService.class);
    protected final AuthenticatedWebResourceProvider provider;
    private final ExecutorService executor;

    protected AbstractRemoteService(AbstractRemoteService other) {
        this(other.provider, other.executor);
    }

    protected AbstractRemoteService(AuthenticatedWebResourceProvider provider, ExecutorService executor) {
        this.provider = provider;
        this.executor = executor;
    }

    protected ExecutorService getExecutor() {
        return this.executor;
    }

    protected WebResource newRestWebResource() {
        return this.provider.newRestWebResource().path("rest").path("api");
    }

    protected WebResource newExperimentalRestWebResource() {
        return this.provider.newRestWebResource().path("rest").path("experimental");
    }

    protected <T> CompletionStage<T> getCompletionStage(WebResource resource, Class<? extends T> entityClass) {
        return CompletableFuture.supplyAsync(() -> this.getOptional(resource, entityClass).orElseThrow(NotFoundException::new), this.executor);
    }

    protected <T> CompletionStage<Optional<T>> getCompletionStageOptional(WebResource resource, Class<? extends T> entityClass) {
        return CompletableFuture.supplyAsync(() -> this.getOptional(resource, entityClass), this.executor);
    }

    protected <E> CompletionStage<PageResponse<E>> getCompletionStagePageResponseList(WebResource resource, Class<E> contentClass) {
        return CompletableFuture.supplyAsync(() -> this.getPartialList(resource, contentClass), this.executor);
    }

    protected <E> CompletionStage<SearchPageResponse<E>> getCompletionStageSearchPageResponseList(WebResource resource, Class<E> contentClass) {
        return CompletableFuture.supplyAsync(() -> this.getSearchPartialList(resource, contentClass), this.executor);
    }

    protected <K, V> CompletionStage<Map<K, PageResponse<V>>> getCompletionStageMapOfPageResponses(WebResource resource, Class<K> keyClass, Class<V> listContentClass) {
        GenericType<Map> mapType = this.getGenericType(Map.class, keyClass, AbstractRemoteService.getParameterizedType(RestList.class, listContentClass));
        return this.getCompletionStageGenericMap(resource, mapType);
    }

    protected <K, V> CompletionStage<Map<K, V>> getCompletionStageMap(WebResource resource, Class<K> keyClass, Class<V> valueClass) {
        GenericType<Map> mapType = this.getGenericType(Map.class, keyClass, valueClass);
        return this.getCompletionStageGenericMap(resource, mapType);
    }

    protected <E> CompletionStage<Iterable<E>> getCompletionStageGenericCollection(WebResource resource, Class<? extends Iterable> collectionType, Class<E> contentType) {
        return CompletableFuture.supplyAsync(() -> this.getGenericIterable(resource, collectionType, contentType), this.executor);
    }

    protected <E> CompletionStage<E> postCompletionStage(WebResource resource, Class<? extends E> entityClass, @Nullable Object postEntity) {
        return this.postCompletionStage(resource, entityClass, postEntity, MediaType.APPLICATION_JSON_TYPE);
    }

    protected <E> CompletionStage<E> postCompletionStage(WebResource resource, Class<? extends E> entityClass, @Nullable Object postEntity, MediaType mediaType) {
        return CompletableFuture.supplyAsync(() -> this.post(resource, entityClass, postEntity, mediaType), this.executor);
    }

    protected CompletionStage<Void> postVoidCompletionStage(WebResource resource, @Nullable Object postEntity) {
        return CompletableFuture.runAsync(() -> this.postVoid(resource, postEntity, MediaType.APPLICATION_JSON_TYPE), this.executor);
    }

    protected <E> CompletionStage<E> postCompletionStage(WebResource resource, Class<E> collectionClass, Class contentType, Object postEntity) {
        return CompletableFuture.supplyAsync(() -> this.post(resource, collectionClass, contentType, postEntity), this.executor);
    }

    protected <T> CompletionStage<PageResponse<T>> postCompletionStageToPageResponse(WebResource resource, Class<T> entityClass, Object postEntity, MediaType mediaType) {
        return CompletableFuture.supplyAsync(() -> this.postToPageResponse(resource, entityClass, postEntity, mediaType), this.executor);
    }

    protected <T> CompletionStage<T> putCompletionStage(WebResource resource, Class<? extends T> entityClass, @Nullable Object putEntity) {
        return CompletableFuture.supplyAsync(() -> this.put(resource, entityClass, putEntity), this.executor);
    }

    protected CompletionStage<Void> deleteCompletionStage(WebResource resource) {
        return this.deleteCompletionStage(resource, Void.class);
    }

    protected <T> CompletionStage<T> deleteCompletionStage(WebResource resource, Class<? extends T> responseClass) {
        return CompletableFuture.supplyAsync(() -> this.delete(resource, responseClass), this.executor);
    }

    protected WebResource addExpansions(WebResource resource, @Nullable Expansion[] expansions) {
        if (expansions == null || expansions.length == 0) {
            return resource;
        }
        return resource.queryParam("expand", ExpansionsParser.asString((Expansion[])expansions));
    }

    protected WebResource addPageRequestParams(WebResource resource, @Nullable PageRequest request) {
        if (request == null) {
            return resource;
        }
        resource = request.getCursor() != null ? resource.queryParam("cursor", request.getCursor().toString()) : resource.queryParam("start", Integer.toString(request.getStart()));
        return resource.queryParam("limit", Integer.toString(request.getLimit()));
    }

    private <E> Optional<E> getOptional(WebResource resource, Class<? extends E> clazz) throws ServiceException {
        try {
            Object entity = resource.get(clazz);
            return Optional.of(entity);
        }
        catch (UniformInterfaceException e) {
            if (e.getResponse().getStatusInfo().getStatusCode() == ClientResponse.Status.NOT_FOUND.getStatusCode()) {
                log.debug("404 being converted to Optional.empty : {}", (Object)e.getMessage());
                return Optional.empty();
            }
            throw ExceptionConverter.Client.convertToServiceException(e);
        }
    }

    private <E> PageResponse<E> getPartialList(WebResource resource, Class<E> contentClass) throws ServiceException {
        return (PageResponse)this.getGenericIterable(resource, RestList.class, contentClass);
    }

    private <E> SearchPageResponse<E> getSearchPartialList(WebResource resource, Class<E> contentClass) throws ServiceException {
        RestList restList = (RestList)this.getGenericIterable(resource, RestList.class, contentClass);
        SearchPageResponse.Builder builder = SearchPageResponse.builder().result((Iterable)restList).pageRequest(restList.getPageRequest()).hasMore(restList.hasMore()).cqlQuery((String)restList.getProperty("cqlQuery")).totalSize(((Integer)restList.getProperty("totalSize")).intValue()).searchDuration(((Integer)restList.getProperty("searchDuration")).intValue());
        if (restList.hasProperty("archivedResultCount")) {
            builder.withArchivedResultCount(Optional.of((Integer)restList.getProperty("archivedResultCount")));
        }
        return builder.build();
    }

    private <G> GenericType<G> getGenericType(Class<G> collectionType, Type ... typeParameters) {
        return new GenericType((Type)AbstractRemoteService.getParameterizedType(collectionType, typeParameters));
    }

    private static ParameterizedType getParameterizedType(final Class type, final Type ... typeParameters) {
        return new ParameterizedType(){

            @Override
            public Type[] getActualTypeArguments() {
                return typeParameters;
            }

            @Override
            public Type getRawType() {
                return type;
            }

            @Override
            public Type getOwnerType() {
                return null;
            }
        };
    }

    private <K, V> CompletionStage<Map<K, V>> getCompletionStageGenericMap(WebResource resource, GenericType<Map> mapType) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Map map = (Map)resource.get(mapType);
                return map.entrySet().stream().filter(entry -> !entry.getKey().toString().startsWith("_")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            }
            catch (UniformInterfaceException e) {
                throw ExceptionConverter.Client.convertToServiceException(e);
            }
        }, this.executor);
    }

    private <T> Iterable<T> getGenericIterable(WebResource resource, Class<? extends Iterable> collectionType, Class<T> contentClass) throws ServiceException {
        try {
            return (Iterable)resource.get(this.getGenericType(collectionType, contentClass));
        }
        catch (UniformInterfaceException e) {
            throw ExceptionConverter.Client.convertToServiceException(e);
        }
    }

    private <T> PageResponse<T> postToPageResponse(WebResource resource, final Class<T> contentClass, Object postEntity, MediaType mediaType) throws ServiceException {
        try {
            ParameterizedType restListType = new ParameterizedType(){

                @Override
                public Type[] getActualTypeArguments() {
                    return new Type[]{contentClass};
                }

                @Override
                public Type getRawType() {
                    return RestList.class;
                }

                @Override
                public @Nullable Type getOwnerType() {
                    return null;
                }
            };
            mediaType = MediaTypeUtils.addBoundary(mediaType);
            WebResource.Builder builder = resource.type(mediaType);
            this.setAtlassianTokenIfNeeded(builder, mediaType);
            return (PageResponse)builder.post(new GenericType((Type)restListType), postEntity);
        }
        catch (UniformInterfaceException e) {
            throw ExceptionConverter.Client.convertToServiceException(e);
        }
    }

    private <T> T post(WebResource resource, Class<? extends T> clazz, @Nullable Object postEntity, MediaType mediaType) throws ServiceException {
        try {
            mediaType = MediaTypeUtils.addBoundary(mediaType);
            WebResource.Builder builder = resource.type(mediaType);
            this.setAtlassianTokenIfNeeded(builder, mediaType);
            return (T)builder.post(clazz, postEntity);
        }
        catch (UniformInterfaceException e) {
            throw ExceptionConverter.Client.convertToServiceException(e);
        }
    }

    private <T> T post(WebResource resource, Class<T> collectionType, Class contentClass, Object postEntity) throws ServiceException {
        try {
            GenericType<T> type = this.getGenericType(collectionType, contentClass);
            return (T)resource.type(MediaType.APPLICATION_JSON_TYPE).post(type, postEntity);
        }
        catch (UniformInterfaceException e) {
            throw ExceptionConverter.Client.convertToServiceException(e);
        }
    }

    private void postVoid(WebResource resource, @Nullable Object postEntity, MediaType mediaType) throws ServiceException {
        try {
            mediaType = MediaTypeUtils.addBoundary(mediaType);
            WebResource.Builder builder = resource.type(mediaType);
            this.setAtlassianTokenIfNeeded(builder, mediaType);
            builder.post(postEntity);
        }
        catch (UniformInterfaceException e) {
            throw ExceptionConverter.Client.convertToServiceException(e);
        }
    }

    private void setAtlassianTokenIfNeeded(WebResource.Builder builder, MediaType mediaType) {
        if (mediaType != MediaType.APPLICATION_JSON_TYPE) {
            builder.header("X-Atlassian-Token", (Object)"no-check");
        }
    }

    private <T> @Nullable T put(WebResource resource, Class<? extends T> clazz, @Nullable Object putEntity) throws ServiceException {
        try {
            WebResource.Builder builder = resource.type(MediaType.APPLICATION_JSON_TYPE);
            if (clazz == Void.class) {
                builder.put();
                return null;
            }
            return (T)builder.put(clazz, putEntity);
        }
        catch (UniformInterfaceException e) {
            throw ExceptionConverter.Client.convertToServiceException(e);
        }
    }

    private <T> @Nullable T delete(WebResource resource, Class<? extends T> clazz) throws ServiceException {
        try {
            WebResource.Builder builder = resource.type(MediaType.APPLICATION_JSON_TYPE);
            if (clazz == Void.class) {
                builder.delete();
                return null;
            }
            return (T)builder.delete(clazz);
        }
        catch (UniformInterfaceException e) {
            throw ExceptionConverter.Client.convertToServiceException(e);
        }
    }

    protected WebResource addPageRequest(WebResource resource, PageRequest pageRequest) {
        return this.addPageRequestParams(resource, pageRequest);
    }
}

