/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentStatus;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.service.exceptions.unchecked.NotImplementedServiceException;
import com.atlassian.confluence.rest.client.AbstractRemoteContentService;
import com.atlassian.confluence.rest.client.RemoteContentService;
import com.atlassian.confluence.rest.client.authentication.AuthenticatedWebResourceProvider;
import com.sun.jersey.api.client.WebResource;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;

public class RemoteContentServiceImpl
extends AbstractRemoteContentService {
    public RemoteContentServiceImpl(AuthenticatedWebResourceProvider provider, ExecutorService executor) {
        super(provider, executor);
    }

    @Override
    public RemoteContentService.RemoteContentFinder find(Expansion ... expansions) {
        return new RemoteContentFinderImpl(this, expansions);
    }

    public class RemoteContentFinderImpl
    extends AbstractRemoteContentService.AbstractRemoteContentFinder {
        private final Expansion[] expansions;

        RemoteContentFinderImpl(RemoteContentServiceImpl otherService, Expansion ... expansions) {
            super(otherService, new Expansion[0]);
            this.expansions = expansions;
        }

        @Override
        public CompletionStage<PageResponse<Content>> fetchManyCompletionStage(ContentType type, PageRequest request) {
            WebResource webResource = RemoteContentServiceImpl.this.newContentWebResource();
            if (this.title != null) {
                webResource = webResource.queryParam("title", this.title);
            }
            if (this.spaceKey != null) {
                webResource = webResource.queryParam("spaceKey", this.spaceKey);
            }
            webResource = this.handleStatuses(webResource);
            webResource = webResource.queryParam("type", type.getType());
            if (this.createdDate != null) {
                webResource = webResource.queryParam("postingDay", this.createdDate.toString());
            }
            webResource = this.addExpansions(webResource, this.expansions);
            webResource = this.addPageRequest(webResource, request);
            return this.getCompletionStagePageResponseList(webResource, Content.class);
        }

        @Override
        public CompletionStage<Map<ContentType, PageResponse<Content>>> fetchMappedByContentTypeCompletionStage(PageRequest request) {
            throw new NotImplementedServiceException("fetchMappedByContentType not yet supported");
        }

        @Override
        protected CompletionStage<Optional<Content>> fetchByIdCompletionStage() {
            if (RemoteContentServiceImpl.this.containsExperimentalExpansion(this.expansions)) {
                return this.fetchByIdCompletionStage(RemoteContentServiceImpl.this::newExperimentalContentWebResource);
            }
            return this.fetchByIdCompletionStage(RemoteContentServiceImpl.this::newContentWebResource);
        }

        private CompletionStage<Optional<Content>> fetchByIdCompletionStage(Supplier<WebResource> webResourceSupplier) {
            WebResource webResource = webResourceSupplier.get().path(this.contentId.serialise());
            if (this.version > 0) {
                webResource = webResource.queryParam("version", String.valueOf(this.version));
            }
            webResource = this.addExpansions(webResource, this.expansions);
            webResource = this.handleStatuses(webResource);
            return this.getCompletionStageOptional(webResource, Content.class);
        }

        private WebResource handleStatuses(WebResource webResource) {
            boolean onlyContainsCurrent;
            boolean bl = onlyContainsCurrent = this.getStatuses().contains(ContentStatus.CURRENT) && this.getStatuses().size() == 1;
            if (this.getStatuses().isEmpty()) {
                webResource = webResource.queryParam("status", "any");
            } else if (!onlyContainsCurrent) {
                for (ContentStatus status : this.getStatuses()) {
                    webResource = webResource.queryParam("status", status.serialise());
                }
            }
            return webResource;
        }

        @Override
        protected WebResource addPageRequest(WebResource resource, PageRequest pageRequest) {
            if (pageRequest.getCursor() != null) {
                resource = resource.path("scan");
            }
            return super.addPageRequest(resource, pageRequest);
        }
    }
}

