/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client.graphql;

import com.atlassian.annotations.Internal;
import com.atlassian.confluence.api.model.BaseApiEnum;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.GraphQLQueryExpansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentStatus;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.service.exceptions.NotFoundException;
import com.atlassian.confluence.rest.client.AbstractRemoteContentService;
import com.atlassian.confluence.rest.client.RemoteContentService;
import com.atlassian.confluence.rest.client.authentication.AuthenticatedWebResourceProvider;
import com.atlassian.confluence.rest.client.graphql.GraphQLQueryResponse;
import com.atlassian.confluence.rest.client.graphql.GraphQLUtils;
import com.atlassian.confluence.rest.serialization.graphql.GraphQLPageResponse;
import com.atlassian.fugue.Option;
import com.atlassian.util.concurrent.Promise;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.sun.jersey.api.client.WebResource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

@Internal
public class GraphQLRemoteContentServiceImpl
extends AbstractRemoteContentService {
    private String defaultGraphQLQuery;

    public GraphQLRemoteContentServiceImpl(AuthenticatedWebResourceProvider provider, ListeningExecutorService executor, String defaultGraphQLQuery) {
        super(provider, executor);
        this.defaultGraphQLQuery = Objects.requireNonNull(defaultGraphQLQuery);
    }

    @Override
    public RemoteContentService.RemoteContentFinder find(Expansion ... expansions) {
        return new RemoteContentFinderImpl((AbstractRemoteContentService)this, expansions);
    }

    public static class GraphQLQueryContentResponse
    extends GraphQLQueryResponse<Map<String, GraphQLPageResponse<Content>>> {
    }

    protected class RemoteContentFinderImpl
    extends AbstractRemoteContentService.AbstractRemoteContentFinder {
        private String graphqlQuery;

        RemoteContentFinderImpl(AbstractRemoteContentService otherService, Expansion ... expansions) {
            super(otherService, expansions);
            this.graphqlQuery = GraphQLRemoteContentServiceImpl.this.defaultGraphQLQuery;
            if (expansions.length != 0) {
                if (expansions.length > 1 || !(expansions[0] instanceof GraphQLQueryExpansion)) {
                    throw new IllegalArgumentException("Expected a single expansion of type '" + GraphQLQueryExpansion.class.getSimpleName() + "'");
                }
                this.graphqlQuery = ((GraphQLQueryExpansion)expansions[0]).getQuery();
            }
        }

        @Override
        public Promise<PageResponse<Content>> fetchMany(ContentType type, PageRequest request) {
            HashMap<String, Object> queryArguments = new HashMap<String, Object>();
            if (request != null) {
                queryArguments.put("offset", request.getStart());
                queryArguments.put("first", request.getLimit());
            }
            if (this.title != null) {
                queryArguments.put("title", this.title);
            }
            if (this.spaceKey != null) {
                queryArguments.put("spaceKey", this.spaceKey);
            }
            if (this.statuses != null) {
                this.handleStatuses(queryArguments);
            }
            queryArguments.put("type", type.getType());
            if (this.createdDate != null) {
                queryArguments.put("postingDay", this.createdDate.toString("yyyy-MM-dd"));
            }
            String requestString = GraphQLUtils.buildRequestString("content", this.graphqlQuery, queryArguments);
            Promise<GraphQLQueryContentResponse> responsePromise = this.postFuture(this.newGraphWebResource(), GraphQLQueryContentResponse.class, requestString);
            return responsePromise.map(response -> {
                response.throwFirstErrorIfExists();
                return (PageResponse)((Map)response.getData()).get("content");
            });
        }

        @Override
        protected Promise<Option<Content>> fetchOneById() {
            HashMap<String, Object> queryArguments = new HashMap<String, Object>();
            queryArguments.put("id", this.contentId.serialise());
            if (this.version > 0) {
                queryArguments.put("version", this.version);
            }
            if (this.statuses != null) {
                this.handleStatuses(queryArguments);
            }
            String requestString = GraphQLUtils.buildRequestString("content", this.graphqlQuery, queryArguments);
            Promise<GraphQLQueryContentResponse> responsePromise = this.postFuture(this.newGraphWebResource(), GraphQLQueryContentResponse.class, requestString);
            return responsePromise.map(response -> {
                try {
                    response.throwFirstErrorIfExists();
                }
                catch (NotFoundException ex) {
                    return Option.none();
                }
                PageResponse pageResponse = (PageResponse)((Map)response.getData()).get("content");
                return pageResponse.size() != 0 ? Option.some(pageResponse.getResults().get(0)) : Option.none();
            });
        }

        private void handleStatuses(Map<String, Object> arguments) {
            if (this.statuses.isEmpty()) {
                arguments.put("status", "any");
            } else if (!this.statuses.equals((Object)ImmutableList.of((Object)ContentStatus.CURRENT))) {
                List statusList = this.statuses.stream().map(BaseApiEnum::getValue).collect(Collectors.toList());
                arguments.put("status", statusList);
            }
        }

        private WebResource newGraphWebResource() {
            return this.provider.newRestWebResource().path("rest").path("graph");
        }
    }
}

