/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client.proxy;

import com.atlassian.confluence.rest.client.AbstractRemoteService;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteServiceProxyCreator {
    private static final Logger log = LoggerFactory.getLogger(RemoteServiceProxyCreator.class);
    private static final int timeoutSecs = 30;

    public static <T> T createProxy(AbstractRemoteService<T> remoteService) {
        Class proxyClass;
        ParameterizedType parameterizedType = (ParameterizedType)remoteService.getClass().getGenericSuperclass();
        Type proxyType = parameterizedType.getActualTypeArguments()[0];
        if (proxyType instanceof Class) {
            proxyClass = (Class)proxyType;
        } else if (proxyType instanceof ParameterizedType) {
            proxyClass = (Class)((ParameterizedType)proxyType).getRawType();
        } else {
            throw new IllegalStateException("Unhandled type: " + proxyType);
        }
        if (proxyClass == null) {
            throw new IllegalArgumentException("RemoteService to be proxied does not supply generic local service type to AbstractRemoteService.  Ensure the type parameter on AbstractRemoteService is specified correctly.");
        }
        return proxyClass.cast(Proxy.newProxyInstance(proxyClass.getClassLoader(), new Class[]{proxyClass}, RemoteServiceProxyCreator.createInvocationHandler(remoteService)));
    }

    private static <T> InvocationHandler createInvocationHandler(AbstractRemoteService<T> remoteService) {
        return (proxy, method, args) -> {
            Method remoteMethod;
            try {
                remoteMethod = remoteService.getClass().getMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException nsme) {
                log.error("Proxied remote service: {} is missing a method: {}", (Object)remoteService.getClass().getSimpleName(), (Object)method.getName());
                throw nsme;
            }
            if (Future.class.isAssignableFrom(remoteMethod.getReturnType())) {
                try {
                    Future future = (Future)remoteMethod.invoke((Object)remoteService, args);
                    return future.get(30L, TimeUnit.SECONDS);
                }
                catch (ExecutionException ex) {
                    throw ex.getCause();
                }
            }
            if (remoteMethod.getReturnType().equals(method.getReturnType())) {
                return remoteMethod.invoke((Object)remoteService, args);
            }
            if (method.getReturnType().isInterface() && remoteMethod.getReturnType().isInterface()) {
                Object potentialRemoteService = remoteMethod.invoke((Object)remoteService, args);
                if (potentialRemoteService instanceof AbstractRemoteService) {
                    return RemoteServiceProxyCreator.createProxy((AbstractRemoteService)potentialRemoteService);
                }
                throw new NoSuchMethodException("Remote service " + remoteService.getClass().getSimpleName() + " has a matching method (" + method.getName() + ") but the result does not extend AbstractRemoteService: " + potentialRemoteService);
            }
            throw new NoSuchMethodException(String.format("Remote method : %s has incompatible return type %s with proxy service method return type %s", remoteMethod.getName(), remoteMethod.getReturnType(), method.getReturnType()));
        };
    }
}

