/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.api.model.validation;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.api.model.validation.SimpleValidationResult;
import com.atlassian.confluence.api.model.validation.ValidationError;
import com.atlassian.confluence.api.model.validation.ValidationResult;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.api.service.exceptions.PermissionException;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.rest.api.model.validation.RestValidationError;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonDeserialize;

@JsonIgnoreProperties(ignoreUnknown=true)
@ExperimentalApi
public class RestValidationResult
implements ValidationResult {
    @JsonProperty
    private final boolean authorized;
    @JsonProperty
    private final boolean valid;
    @JsonDeserialize(contentAs=RestValidationError.class)
    @JsonProperty
    private final List<ValidationError> errors;

    @JsonCreator
    private RestValidationResult() {
        this(null);
    }

    public RestValidationResult(ValidationResult that) {
        if (that == null) {
            that = SimpleValidationResult.builder().build();
        }
        this.authorized = that.isAuthorized();
        this.valid = that.isValid();
        this.errors = Lists.newArrayList((Iterable)Iterables.transform((Iterable)that.getErrors(), (Function)new Function<ValidationError, ValidationError>(){

            public ValidationError apply(ValidationError input) {
                return new RestValidationError(input);
            }
        }));
    }

    public boolean isAuthorized() {
        return this.authorized;
    }

    public boolean isValid() {
        return this.valid;
    }

    public Iterable<ValidationError> getErrors() {
        return this.errors;
    }

    public ServiceException throwIfInvalid(String msg) throws ServiceException {
        if (!this.isAuthorized() || !this.isValid()) {
            throw this.convertToServiceException(msg);
        }
        return null;
    }

    private ServiceException convertToServiceException(String errorMsg) {
        if (!this.isAuthorized()) {
            return new PermissionException(errorMsg, (ValidationResult)this);
        }
        return new BadRequestException(errorMsg, (ValidationResult)this);
    }

    public String toString() {
        return "RestValidationResult{ valid=" + this.valid + ", authorized=" + this.authorized + ", errors=" + this.errors + '}';
    }
}

