/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.api.incrementalsync.model;

import com.atlassian.confluence.api.model.pagination.Cursor;
import com.atlassian.confluence.api.model.pagination.CursorType;
import java.io.Serializable;
import java.util.Objects;

public class IncrementalSyncCursor
implements Cursor,
Serializable {
    private static final long serialVersionUID = -189558794435673720L;
    private final long subscriptionId;
    private final long mostRecentId;

    public IncrementalSyncCursor(long subscriptionId, long mostRecentId) {
        this.subscriptionId = subscriptionId;
        this.mostRecentId = mostRecentId;
    }

    public boolean isReverse() {
        return false;
    }

    public boolean isEmpty() {
        return false;
    }

    public CursorType getCursorType() {
        return CursorType.SYNC;
    }

    public long getSubscriptionId() {
        return this.subscriptionId;
    }

    public long getMostRecentId() {
        return this.mostRecentId;
    }

    public static IncrementalSyncCursor of(String cursor) {
        if (cursor == null) {
            throw new IllegalArgumentException("Cursor couldn't be null");
        }
        String[] cursorArray = cursor.split(":");
        if (cursorArray.length != 3) {
            throw new IllegalArgumentException("Invalid cursor format. Cursor should be in next format: `sync:subscriptionId:mostRecentId`");
        }
        if (!CursorType.SYNC.getType().equalsIgnoreCase(cursorArray[0])) {
            throw new IllegalArgumentException(String.format("Illegal cursor type. Expected %s, but received %s", CursorType.SYNC.getType(), cursorArray[0]));
        }
        try {
            long subscriptionId = Long.parseLong(cursorArray[1]);
            long mostRecentId = Long.parseLong(cursorArray[2]);
            return new IncrementalSyncCursor(subscriptionId, mostRecentId);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid cursor format. Failed to parse long from subscriptionId and mostRecentId");
        }
    }

    public String toString() {
        return String.join((CharSequence)":", this.getCursorType().getType(), String.valueOf(this.subscriptionId), String.valueOf(this.mostRecentId));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncrementalSyncCursor that = (IncrementalSyncCursor)o;
        return Objects.equals(this.subscriptionId, that.subscriptionId) && Objects.equals(this.mostRecentId, that.mostRecentId);
    }

    public int hashCode() {
        return Objects.hash(this.subscriptionId, this.mostRecentId);
    }
}

