/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.content;

import com.atlassian.confluence.api.model.BaseApiEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class ContentStatus
extends BaseApiEnum {
    private static final String DELETED = "deleted";
    public static final ContentStatus CURRENT = new ContentStatus("current");
    public static final ContentStatus TRASHED = new ContentStatus("trashed");
    public static final ContentStatus HISTORICAL = new ContentStatus("historical");
    public static final ContentStatus DRAFT = new ContentStatus("draft");
    public static final List<ContentStatus> BUILT_IN = Collections.unmodifiableList(Arrays.asList(CURRENT, TRASHED, HISTORICAL, DRAFT));

    @JsonCreator
    public static ContentStatus valueOf(String str) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        for (ContentStatus status : BUILT_IN) {
            if (!status.getValue().equals(str)) continue;
            return status;
        }
        return new ContentStatus(str);
    }

    public static List<String> getStatusNames(List<ContentStatus> statuses) {
        return statuses.stream().map(contentStatus -> TRASHED.equals(contentStatus) ? DELETED : contentStatus.getValue()).collect(Collectors.toList());
    }

    private ContentStatus(String status) {
        super(status);
    }
}

