/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.backuprestore;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SpaceBackupSettings {
    @JsonProperty
    @Schema(example="['SPACE1', 'SPACE2']")
    private final Set<String> spaceKeys = new HashSet<String>();
    @JsonProperty
    @Schema(example="true")
    private boolean keepPermanently;
    @JsonProperty
    @Schema(example="backup")
    private String fileNamePrefix;

    @JsonCreator
    public SpaceBackupSettings(@JsonProperty(value="spaceKeys") Collection<String> spaceKeys, @JsonProperty(value="keepPermanently") boolean keepPermanently, @JsonProperty(value="fileNamePrefix") String fileNamePrefix) {
        this.spaceKeys.addAll(spaceKeys);
        this.keepPermanently = keepPermanently;
        this.fileNamePrefix = fileNamePrefix;
    }

    public SpaceBackupSettings() {
    }

    public Set<String> getSpaceKeys() {
        return this.spaceKeys;
    }

    public void setSpaceKeys(Collection<String> spaceKeys) {
        this.spaceKeys.addAll(spaceKeys);
    }

    public boolean isKeepPermanently() {
        return this.keepPermanently;
    }

    public void setKeepPermanently(boolean keepPermanently) {
        this.keepPermanently = keepPermanently;
    }

    public String getFileNamePrefix() {
        return this.fileNamePrefix;
    }

    public void setFileNamePrefix(String fileNamePrefix) {
        this.fileNamePrefix = fileNamePrefix;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Set<String> spaceKeys = new HashSet<String>();
        private boolean keepPermanently;
        private String fileNamePrefix;

        public Builder spaceKeys(Set<String> spaceKeys) {
            this.spaceKeys = new HashSet<String>(spaceKeys);
            return this;
        }

        public Builder keepPermanently(boolean keepPermanently) {
            this.keepPermanently = keepPermanently;
            return this;
        }

        public Builder fileNamePrefix(String fileNamePrefix) {
            this.fileNamePrefix = fileNamePrefix;
            return this;
        }

        public SpaceBackupSettings build() {
            return new SpaceBackupSettings(this.spaceKeys, this.keepPermanently, this.fileNamePrefix);
        }
    }
}

