/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.validation;

import com.atlassian.confluence.api.model.validation.ValidationResult;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.api.service.exceptions.ConflictException;
import com.atlassian.confluence.api.service.exceptions.GoneException;
import com.atlassian.confluence.api.service.exceptions.LicenseUnavailableException;
import com.atlassian.confluence.api.service.exceptions.NotAuthenticatedException;
import com.atlassian.confluence.api.service.exceptions.NotFoundException;
import com.atlassian.confluence.api.service.exceptions.PermissionException;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.api.service.exceptions.unchecked.NotImplementedServiceException;
import java.util.function.BiFunction;
import java.util.function.Supplier;

public class ServiceExceptionSupplier {
    public static BiFunction<String, ValidationResult, ? extends NotFoundException> notFoundExceptionSupplier() {
        return NotFoundException::new;
    }

    public static Supplier<NotFoundException> notFound(String message) {
        return () -> new NotFoundException(message);
    }

    public static BiFunction<String, ValidationResult, ? extends GoneException> goneExceptionSupplier() {
        return GoneException::new;
    }

    public static Supplier<GoneException> goneExceptionSupplier(String errorMsg) {
        return () -> new GoneException(errorMsg);
    }

    public static BiFunction<String, ValidationResult, ? extends ConflictException> conflictExceptionSupplier() {
        return ConflictException::new;
    }

    public static BiFunction<String, ValidationResult, ? extends NotImplementedServiceException> notImplementedSupplier() {
        return NotImplementedServiceException::new;
    }

    public static BiFunction<String, ValidationResult, ? extends BadRequestException> badRequestExceptionSupplier() {
        return BadRequestException::new;
    }

    public static BiFunction<String, ValidationResult, ? extends PermissionException> permissionExceptionExceptionSupplier() {
        return PermissionException::new;
    }

    public static BiFunction<String, ValidationResult, LicenseUnavailableException> licenseUnavailableExceptionSupplier() {
        return LicenseUnavailableException::new;
    }

    public static BiFunction<String, ValidationResult, ServiceException> notAuthenticatedExceptionSupplier() {
        return NotAuthenticatedException::new;
    }
}

