/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.permissions;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.api.model.BaseApiEnum;
import com.atlassian.confluence.api.model.content.ContentType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnore;

@ExperimentalApi
public final class TargetType
extends BaseApiEnum {
    public static final TargetType PAGE = new TargetType(ContentType.PAGE);
    public static final TargetType BLOG_POST = new TargetType(ContentType.BLOG_POST);
    public static final TargetType COMMENT = new TargetType(ContentType.COMMENT);
    public static final TargetType ATTACHMENT = new TargetType(ContentType.ATTACHMENT);
    public static final TargetType SPACE = new TargetType("space");
    public static final List<TargetType> BUILT_IN = ImmutableList.of((Object)PAGE, (Object)BLOG_POST, (Object)COMMENT, (Object)ATTACHMENT, (Object)SPACE);

    @JsonCreator
    public static TargetType valueOf(@NonNull String type) {
        return new TargetType(type);
    }

    @JsonIgnore
    public static TargetType valueOf(@NonNull ContentType type) {
        return new TargetType(type);
    }

    public static Set<TargetType> valuesOf(@NonNull Iterable<String> types) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String type : types) {
            builder.add((Object)TargetType.valueOf(type));
        }
        return builder.build();
    }

    @JsonIgnore
    private TargetType(String type) {
        super((String)Preconditions.checkNotNull((Object)type));
    }

    @JsonIgnore
    private TargetType(ContentType contentType) {
        super((String)Preconditions.checkNotNull((Object)contentType.getValue()));
    }

    public @NonNull String getType() {
        return this.serialise();
    }
}

