/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.search.autocomplete;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.api.model.search.autocomplete.AutocompleteResultItem;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

@ExperimentalApi
@JsonIgnoreProperties(ignoreUnknown=true)
public class AutocompleteResult {
    @JsonProperty
    private final List<AutocompleteResultItem> suggestedResults;
    @JsonProperty
    private final List<AutocompleteResultItem> searchResults;

    @JsonCreator
    private AutocompleteResult() {
        this(AutocompleteResult.builder());
    }

    private AutocompleteResult(Builder builder) {
        this.suggestedResults = ImmutableList.copyOf((Collection)builder.suggestedResults);
        this.searchResults = ImmutableList.copyOf((Collection)builder.searchResults);
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<AutocompleteResultItem> getSuggestedResults() {
        return this.suggestedResults;
    }

    public List<AutocompleteResultItem> getSearchResults() {
        return this.searchResults;
    }

    public static class Builder {
        private List<AutocompleteResultItem> suggestedResults = ImmutableList.of();
        private List<AutocompleteResultItem> searchResults = ImmutableList.of();

        private Builder() {
        }

        public Builder suggestedResults(List<AutocompleteResultItem> suggestedResults) {
            this.suggestedResults = suggestedResults;
            return this;
        }

        public Builder searchResults(List<AutocompleteResultItem> searchResults) {
            this.searchResults = searchResults;
            return this;
        }

        public AutocompleteResult build() {
            return new AutocompleteResult(this);
        }
    }
}

