/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.pagination;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.api.model.pagination.LimitedRequest;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.SkipDiscardLimitedRequest;
import com.google.common.base.MoreObjects;
import java.util.Objects;

@ExperimentalApi
public class LimitedRequestImpl
implements SkipDiscardLimitedRequest {
    private final int start;
    private final int limit;
    private final int needed;
    private final int maxLimit;
    private final boolean shouldSkipDiscardingThreshold;

    public static LimitedRequest create(PageRequest request, int maxLimit) {
        return new LimitedRequestImpl(request, maxLimit);
    }

    public static LimitedRequest create(int maxLimit) {
        return new LimitedRequestImpl(0, maxLimit, maxLimit);
    }

    public static LimitedRequest create(int start, int limit, int maxLimit) {
        return new LimitedRequestImpl(start, limit, maxLimit);
    }

    public static LimitedRequest create(int start, int limit, int maxLimit, boolean shouldSkipDiscardingThreshold) {
        return new LimitedRequestImpl(start, limit, limit, maxLimit, shouldSkipDiscardingThreshold);
    }

    protected LimitedRequestImpl(PageRequest request, int maxLimit) {
        this(request.getStart(), request.getLimit(), request.getLimit(), maxLimit, false);
    }

    protected LimitedRequestImpl(int start, int limit, int maxLimit) {
        this(start, Math.min(limit, maxLimit), Math.min(limit, maxLimit), maxLimit, false);
    }

    protected LimitedRequestImpl(int start, int limit, int needed, int maxLimit) {
        this(start, limit, needed, maxLimit, false);
    }

    protected LimitedRequestImpl(int start, int limit, int needed, int maxLimit, boolean shouldSkipDiscardingThreshold) {
        if (maxLimit < 0) {
            throw new IllegalArgumentException("maxLimit cannot be less than zero");
        }
        if (limit < 0) {
            throw new IllegalArgumentException("limit cannot be less than zero");
        }
        if (start < 0) {
            throw new IllegalArgumentException("start cannot be less than zero");
        }
        this.start = start;
        this.limit = Math.max(0, Math.min(limit, maxLimit));
        this.needed = needed;
        this.maxLimit = maxLimit;
        this.shouldSkipDiscardingThreshold = shouldSkipDiscardingThreshold;
    }

    @Override
    @Deprecated
    public int getNeeded() {
        return this.needed;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    @Override
    public int getMaxLimit() {
        return this.maxLimit;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("start", this.start).add("limit", this.limit).add("needed", this.needed).add("maxLimit", this.maxLimit).add("shouldSkipDiscardingThreshold", this.shouldSkipDiscardingThreshold).toString();
    }

    public int hashCode() {
        return Objects.hash(this.limit, this.maxLimit, this.needed, this.start, this.shouldSkipDiscardingThreshold);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !LimitedRequest.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        if (obj instanceof SkipDiscardLimitedRequest) {
            SkipDiscardLimitedRequest other = (SkipDiscardLimitedRequest)obj;
            return Objects.equals(this.limit, other.getLimit()) && Objects.equals(this.maxLimit, other.getMaxLimit()) && Objects.equals(this.needed, other.getNeeded()) && Objects.equals(this.start, other.getStart()) && Objects.equals(this.shouldSkipDiscardingThreshold, other.shouldSkipDiscardingThreshold());
        }
        LimitedRequest other = (LimitedRequest)obj;
        return Objects.equals(this.limit, other.getLimit()) && Objects.equals(this.maxLimit, other.getMaxLimit()) && Objects.equals(this.needed, other.getNeeded()) && Objects.equals(this.start, other.getStart());
    }

    @Override
    public boolean shouldSkipDiscardingThreshold() {
        return this.shouldSkipDiscardingThreshold;
    }
}

