/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.content;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.people.Person;
import com.atlassian.confluence.api.model.reference.ExpandedReference;
import com.atlassian.confluence.api.model.reference.Reference;
import com.atlassian.confluence.api.nav.Navigation;
import com.atlassian.confluence.api.nav.NavigationAware;
import com.atlassian.confluence.api.nav.NavigationService;
import com.atlassian.confluence.api.serialization.RestEnrichable;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import java.util.Date;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.joda.time.DateTime;
import org.joda.time.ReadableDateTime;

@ExperimentalApi
@RestEnrichable
@JsonIgnoreProperties(ignoreUnknown=true)
public class Version
implements NavigationAware {
    @JsonProperty
    private final Person by;
    @JsonProperty
    private final DateTime when;
    @JsonProperty
    private final String message;
    @JsonProperty
    private final int number;
    @JsonProperty
    private final boolean minorEdit;
    @JsonProperty
    private final boolean hidden;
    @JsonProperty
    private final String syncRev;
    @JsonDeserialize(as=ExpandedReference.class, contentAs=Content.class)
    @JsonProperty
    private final Reference<Content> content;

    public static VersionBuilder builder() {
        return new VersionBuilder();
    }

    public static VersionBuilder builder(Version version) {
        return new VersionBuilder().by(version.by).message(version.message).minorEdit(version.minorEdit).hidden(version.hidden).number(version.number).when((ReadableDateTime)version.when).syncRev(version.syncRev).content(version.content);
    }

    @Override
    public Navigation.Builder resolveNavigation(NavigationService navigationService) {
        if (!this.content.exists()) {
            return null;
        }
        return navigationService.createNavigation().experimental().content(this.content).version(this);
    }

    public static Reference<Version> buildReference(int number) {
        return Reference.collapsed(Version.class, (Map)ImmutableMap.of((Object)((Object)IdProperties.number), (Object)number));
    }

    @Deprecated
    public static Reference<Version> buildReference(Reference<Content> contentRef, int number) {
        return Version.buildReference(number);
    }

    public static int getVersionNumber(Reference<Version> versionRef) {
        if (versionRef == null) {
            return 0;
        }
        Object numberProperty = versionRef.getIdProperty(IdProperties.number);
        if (numberProperty == null) {
            return 0;
        }
        return (Integer)numberProperty;
    }

    @JsonCreator
    private Version() {
        this(Version.builder());
    }

    private Version(VersionBuilder builder) {
        this.by = builder.by;
        this.when = builder.when;
        this.message = builder.message;
        this.number = builder.number;
        this.minorEdit = builder.minorEdit;
        this.hidden = builder.hidden;
        this.syncRev = builder.syncRev;
        this.content = Reference.orEmpty(builder.content, Content.class);
    }

    public Person getBy() {
        return this.by;
    }

    public DateTime getWhen() {
        return this.when;
    }

    public String getMessage() {
        return this.message;
    }

    public int getNumber() {
        return this.number;
    }

    public boolean isMinorEdit() {
        return this.minorEdit;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public String getSyncRev() {
        return this.syncRev;
    }

    public VersionBuilder nextBuilder() {
        return Version.builder().number(this.number + 1);
    }

    public Reference<Content> getContentRef() {
        return this.content;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        return this.number == version.number;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("by", (Object)this.getBy()).add("when", (Object)this.getWhen()).add("number", this.getNumber()).add("message", (Object)this.getMessage()).add("minorEdit", this.isMinorEdit()).add("hidden", this.isHidden()).add("syncrev", (Object)this.getSyncRev()).add("content", this.getContentRef()).toString();
    }

    public int hashCode() {
        return this.number;
    }

    public static class Expansions {
        public static final String CONTENT = "content";
    }

    public static class VersionBuilder {
        private Person by;
        private DateTime when;
        private String message;
        private int number;
        private boolean minorEdit;
        private boolean hidden;
        private String syncRev;
        private Reference<Content> content = Reference.empty(Content.class);

        private VersionBuilder() {
        }

        public Version build() {
            return new Version(this);
        }

        public VersionBuilder by(Person by) {
            this.by = by;
            return this;
        }

        public VersionBuilder when(Date when) {
            if (when != null) {
                this.when = new DateTime((Object)when);
            }
            return this;
        }

        public VersionBuilder when(ReadableDateTime readableDateTime) {
            if (readableDateTime != null) {
                this.when = readableDateTime.toDateTime();
            }
            return this;
        }

        public VersionBuilder message(String message) {
            this.message = message;
            return this;
        }

        public VersionBuilder number(int number) {
            this.number = number;
            return this;
        }

        public VersionBuilder minorEdit(boolean minorEdit) {
            this.minorEdit = minorEdit;
            return this;
        }

        public VersionBuilder hidden(boolean hidden) {
            this.hidden = hidden;
            return this;
        }

        public VersionBuilder syncRev(String syncRev) {
            this.syncRev = syncRev;
            return this;
        }

        public VersionBuilder content(Reference<Content> content) {
            this.content = content;
            return this;
        }
    }

    static enum IdProperties {
        number;

    }
}

