/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.content;

import com.atlassian.confluence.api.model.content.MacroParameterInstance;
import com.atlassian.confluence.api.serialization.RestEnrichable;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

@RestEnrichable
@JsonIgnoreProperties(ignoreUnknown=true)
public class MacroInstance {
    @JsonProperty
    private final String name;
    @JsonProperty
    private final String body;
    @JsonProperty
    private final Map<String, MacroParameterInstance> parameters;

    public static MacroBuilder builder() {
        return new MacroBuilder();
    }

    @JsonCreator
    private MacroInstance() {
        this(MacroInstance.builder());
    }

    private MacroInstance(MacroBuilder builder) {
        this.name = builder.name;
        this.body = builder.body;
        this.parameters = builder.parameters.build();
    }

    public String getName() {
        return this.name;
    }

    public String getBody() {
        return this.body;
    }

    public Map<String, MacroParameterInstance> getParameters() {
        return this.parameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MacroInstance that = (MacroInstance)o;
        return Objects.equal((Object)this.body, (Object)that.body) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal(this.parameters, that.parameters);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.name).append((Object)this.body).append(this.parameters).toHashCode();
    }

    public static class MacroBuilder {
        private String name = null;
        private String body = null;
        private ImmutableMap.Builder<String, MacroParameterInstance> parameters = ImmutableMap.builder();

        private MacroBuilder() {
        }

        public MacroInstance build() {
            return new MacroInstance(this);
        }

        public MacroBuilder name(String name) {
            this.name = name;
            return this;
        }

        public MacroBuilder body(String body) {
            this.body = body;
            return this;
        }

        public MacroBuilder parameters(Map<String, String> parameters) {
            this.parameters.putAll(parameters.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> MacroParameterInstance.builder().value((String)entry.getValue()).build())));
            return this;
        }

        public MacroBuilder addParameter(String key, String value) {
            this.parameters.put((Object)key, (Object)MacroParameterInstance.builder().value(value).build());
            return this;
        }
    }
}

