/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.content;

import com.atlassian.annotations.ExperimentalApi;
import com.google.common.base.Objects;
import java.io.File;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;

@ExperimentalApi
@JsonIgnoreProperties(ignoreUnknown=true)
public class AttachmentUpload {
    private final File file;
    private final String name;
    private final String mediaType;
    private final String comment;
    private final boolean minorEdit;
    private final boolean hidden;

    public AttachmentUpload(File file, String name, String mediaType, String comment, boolean minorEdit) {
        this(file, name, mediaType, comment, minorEdit, false);
    }

    public AttachmentUpload(File file, String name, String mediaType, String comment, boolean minorEdit, boolean hidden) {
        this.file = file;
        this.name = name;
        this.mediaType = mediaType;
        this.comment = comment;
        this.minorEdit = minorEdit;
        this.hidden = hidden;
    }

    public AttachmentUpload withName(String newName) {
        return new AttachmentUpload(this.file, newName, this.mediaType, this.comment, this.minorEdit, this.hidden);
    }

    public String getComment() {
        return this.comment;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public File getFile() {
        return this.file;
    }

    public String getName() {
        return this.name;
    }

    public boolean isMinorEdit() {
        return this.minorEdit;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.name).add("type", (Object)this.mediaType).add("comment", (Object)this.comment).add("minorEdit", this.minorEdit).add("hidden", this.hidden).toString();
    }
}

