/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.reference;

import com.atlassian.annotations.Internal;
import com.atlassian.confluence.api.model.reference.Reference;
import com.atlassian.fugue.Option;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonCreator;

@Internal
public final class ExpandedReference<T>
extends Reference<T> {
    private Map<Object, Object> idProperties;
    private Option<T> of;

    @JsonCreator
    ExpandedReference(T value) {
        super(true);
        this.of = Option.some(value);
    }

    @Override
    public Iterator<T> iterator() {
        return this.of.iterator();
    }

    @Override
    public T get() {
        return (T)this.of.getOrNull();
    }

    public Option<T> option() {
        return this.of;
    }

    @Override
    public boolean exists() {
        return this.of.isDefined();
    }

    @Override
    public boolean isExpanded() {
        return true;
    }

    @Override
    public Map<Object, Object> getIdProperties() {
        if (this.idProperties == null) {
            this.idProperties = ExpandedReference.resolveIdProps(this.get());
        }
        return this.idProperties;
    }

    @Override
    public Class referentClass() {
        return this.of.get().getClass();
    }

    public String toString() {
        return "ExpandedReference{idProperties=" + this.getIdProperties() + ", of=" + this.of + '}';
    }
}

