/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.pagination;

import com.atlassian.confluence.api.model.pagination.LimitedRequest;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PageResponseImpl<T>
implements PageResponse<T> {
    private final PageRequest pageRequest;
    private ImmutableList<T> wrappedList;
    private final boolean hasMore;

    private PageResponseImpl(@JsonProperty(value="hasMore") boolean hasMore) {
        this.pageRequest = null;
        this.hasMore = hasMore;
    }

    private PageResponseImpl(Builder<T> builder) {
        this.wrappedList = ((Builder)builder).listBuilder.build();
        this.hasMore = ((Builder)builder).hasMore;
        this.pageRequest = ((Builder)builder).request;
    }

    private void setResults(List<T> wrappedList) {
        this.wrappedList = ImmutableList.copyOf(wrappedList);
    }

    @Override
    public PageRequest getPageRequest() {
        return this.pageRequest;
    }

    @Override
    public Iterator<T> iterator() {
        return this.wrappedList.iterator();
    }

    @Override
    public int size() {
        return this.wrappedList.size();
    }

    @Override
    public List<T> getResults() {
        return this.wrappedList;
    }

    @Override
    public boolean hasMore() {
        return this.hasMore;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("request", (Object)this.pageRequest).add("hasMore", this.hasMore).add("list", this.wrappedList).toString();
    }

    public static <T> Builder<T> from(Iterable<T> list, boolean hasMore) {
        Builder<T> builder = new Builder<T>();
        builder.addAll(list);
        ((Builder)builder).hasMore = hasMore;
        return builder;
    }

    public static <T> Builder<T> fromSingle(T element, boolean hasMore) {
        if (element != null) {
            return PageResponseImpl.from(Lists.newArrayList((Object[])new Object[]{element}), hasMore);
        }
        return PageResponseImpl.from(new ArrayList(), hasMore);
    }

    public static <F, T> PageResponseImpl<T> transform(PageResponse<F> input, Function<F, T> mapper) {
        Iterable transformedItems = Iterables.transform(input.getResults(), mapper);
        return PageResponseImpl.from(transformedItems, input.hasMore()).pageRequest(input.getPageRequest()).build();
    }

    public static <T> PageResponseImpl<T> empty(boolean hasMore) {
        return PageResponseImpl.from(new ArrayList(), hasMore).build();
    }

    public static <T> PageResponseImpl<T> empty(boolean hasMore, PageRequest request) {
        return PageResponseImpl.from(new ArrayList(), hasMore).pageRequest(request).build();
    }

    public static <T> PageResponseImpl<T> empty(boolean hasMore, LimitedRequest request) {
        return PageResponseImpl.from(new ArrayList(), hasMore).pageRequest(request).build();
    }

    public static <T> PageResponse<T> filteredPageResponse(LimitedRequest limitedRequest, List<T> items, Predicate<? super T> predicate) {
        boolean hasMore;
        boolean bl = hasMore = items.size() > limitedRequest.getLimit();
        if (predicate == null) {
            predicate = Predicates.alwaysTrue();
        }
        ArrayList filteredItems = Lists.newArrayList();
        if (items.size() > limitedRequest.getLimit()) {
            items = items.subList(0, limitedRequest.getLimit());
        }
        for (T item : items) {
            if (!predicate.apply(item)) continue;
            filteredItems.add(item);
        }
        return PageResponseImpl.from(filteredItems, hasMore).pageRequest(limitedRequest).build();
    }

    public static class Builder<T> {
        private boolean hasMore;
        private ImmutableList.Builder<T> listBuilder = ImmutableList.builder();
        private PageRequest request;

        public PageResponseImpl<T> build() {
            return new PageResponseImpl(this);
        }

        public Builder<T> add(T add) {
            this.listBuilder.add(add);
            return this;
        }

        public Builder<T> addAll(Iterable<T> toAdd) {
            this.listBuilder.addAll(toAdd);
            return this;
        }

        public Builder<T> pageRequest(PageRequest request) {
            this.request = request;
            return this;
        }

        public Builder<T> pageRequest(LimitedRequest limitedRequest) {
            this.request = new SimplePageRequest(limitedRequest);
            return this;
        }
    }
}

