/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.diagnostics.ipd.synchrony;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.internal.diagnostics.ipd.metric.type.IpdConnectionStateType;
import com.atlassian.confluence.setup.settings.DarkFeaturesManager;
import com.atlassian.confluence.status.service.SynchronyStatusService;
import com.atlassian.diagnostics.internal.ipd.IpdMetricRegistry;
import com.atlassian.diagnostics.internal.ipd.metrics.IpdCustomMetric;
import com.atlassian.diagnostics.ipd.internal.spi.IpdJob;
import com.atlassian.diagnostics.ipd.internal.spi.IpdJobRunner;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.util.profiling.MetricTag;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynchronyConnectionIpdJob
implements IpdJob {
    static final String SYNCHRONY_INTEROP_PLUGIN_KEY = "com.atlassian.confluence.plugins.synchrony-interop";
    static final String SYNCHRONY_CONNECTION_STATE = "synchrony.connection.state";
    static final String SITE_WIDE_SHARED_DRAFTS_DARK_FEATURE_DISABLE = "site-wide.shared-drafts.disable";
    static final String SYNCHRONY_CONNECTION_STATE_CUSTOM = "synchrony.connection.state.custom";
    private final PluginAccessor pluginAccessor;
    private final AtomicBoolean hasOutageBeenLogged = new AtomicBoolean(false);
    private final IpdMetricRegistry ipdMainRegistry;
    private final SynchronyStatusService synchronyStatusService;
    private final DarkFeaturesManager darkFeaturesManager;
    private final Logger logger;
    private final IpdJobRunner ipdJobRunner;

    SynchronyConnectionIpdJob(IpdJobRunner ipdJobRunner, PluginAccessor pluginAccessor, IpdMetricRegistry ipdMainRegistry, SynchronyStatusService synchronyStatusService, DarkFeaturesManager darkFeaturesManager) {
        this(ipdJobRunner, pluginAccessor, ipdMainRegistry, synchronyStatusService, darkFeaturesManager, LoggerFactory.getLogger(SynchronyConnectionIpdJob.class));
    }

    @VisibleForTesting
    SynchronyConnectionIpdJob(IpdJobRunner ipdJobRunner, PluginAccessor pluginAccessor, IpdMetricRegistry ipdMainRegistry, SynchronyStatusService synchronyStatusService, DarkFeaturesManager darkFeaturesManager, Logger logger) {
        this.ipdJobRunner = Objects.requireNonNull(ipdJobRunner);
        this.pluginAccessor = Objects.requireNonNull(pluginAccessor);
        this.ipdMainRegistry = Objects.requireNonNull(ipdMainRegistry);
        this.synchronyStatusService = Objects.requireNonNull(synchronyStatusService);
        this.darkFeaturesManager = Objects.requireNonNull(darkFeaturesManager);
        this.logger = Objects.requireNonNull(logger);
    }

    @PostConstruct
    void register() {
        this.ipdJobRunner.register((IpdJob)this);
    }

    public void runJob() {
        if (this.isSharedDraftsExplicitlyDisabled()) {
            if (!this.hasOutageBeenLogged.getAndSet(true)) {
                this.logger.info("Shared drafts are disabled, skipping synchrony connection IPD job");
            }
            this.removeMetric();
            return;
        }
        if (!this.pluginAccessor.isPluginEnabled(SYNCHRONY_INTEROP_PLUGIN_KEY)) {
            if (!this.hasOutageBeenLogged.getAndSet(true)) {
                this.logger.info("Synchrony interop plugin is disabled, skipping synchrony connection IPD job");
            }
            this.removeMetric();
            return;
        }
        boolean isUp = this.synchronyStatusService.isSynchronyRunning();
        if (this.hasOutageBeenLogged.getAndSet(false)) {
            this.logger.info("Synchrony is {}", (Object)(isUp ? "Up" : "Down"));
        }
        this.getCustomMetric().update(b -> b.setConnected(isUp));
    }

    public boolean isSharedDraftsExplicitlyDisabled() {
        return this.darkFeaturesManager.getSiteDarkFeatures().isFeatureEnabled(SITE_WIDE_SHARED_DRAFTS_DARK_FEATURE_DISABLE);
    }

    private IpdCustomMetric<IpdConnectionStateType> getCustomMetric() {
        return (IpdCustomMetric)this.ipdMainRegistry.register(IpdCustomMetric.builder((String)SYNCHRONY_CONNECTION_STATE, IpdConnectionStateType.class, (MetricTag.RequiredMetricTag[])new MetricTag.RequiredMetricTag[0]));
    }

    private void removeMetric() {
        this.ipdMainRegistry.removeIf(m -> m.getMetricKey().getMetricName().equals(SYNCHRONY_CONNECTION_STATE_CUSTOM));
    }
}

