/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.diagnostics.ipd.mail.outgoing;

import com.atlassian.confluence.internal.diagnostics.ipd.mail.ConnectionVerifier;
import com.atlassian.mail.MailException;
import com.atlassian.mail.server.MailServer;
import com.atlassian.mail.server.auth.AuthenticationContextAware;
import javax.mail.MessagingException;
import javax.mail.Service;
import javax.mail.Session;
import javax.mail.Transport;
import javax.naming.NamingException;

class DefaultSmtpConnectionVerifier
implements ConnectionVerifier {
    DefaultSmtpConnectionVerifier() {
    }

    @Override
    public void verifyConnection(MailServer mailServer) throws NamingException, MailException, MessagingException {
        Session sessionWithTimeout = ConnectionVerifier.cloneSessionWithMaxTimeout(mailServer.getSession(), 10000L);
        try (Transport transport = sessionWithTimeout.getTransport();){
            if (mailServer instanceof AuthenticationContextAware) {
                AuthenticationContextAware aware = (AuthenticationContextAware)mailServer;
                aware.getAuthenticationContext().connectService((Service)transport);
            } else {
                transport.connect();
            }
            if (!transport.isConnected()) {
                throw new MailException("Failed to connect to SMTP server");
            }
        }
    }
}

