/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.diagnostics.ipd.http;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.internal.diagnostics.ipd.http.IpdHttpMonitoringService;
import com.atlassian.confluence.internal.diagnostics.ipd.http.session.HttpSessionTracker;
import com.atlassian.confluence.util.MemoizingComponentReference;
import com.atlassian.spring.container.ContainerManager;
import java.io.IOException;
import java.util.Optional;
import java.util.function.Supplier;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

@UnrestrictedAccess
public class IpdHttpMonitoringFilter
implements Filter {
    private final Supplier<IpdHttpMonitoringService> monitoringServiceRef = MemoizingComponentReference.containerComponent((String)"ipdHttpMonitoringService");
    private final Supplier<HttpSessionTracker> sessionTrackerRef = MemoizingComponentReference.containerComponent((String)"httpSessionTracker");

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (ContainerManager.isContainerSetup()) {
            Optional.ofNullable(this.monitoringServiceRef.get()).ifPresent(service -> service.registerHttpRequest(request));
            Optional.ofNullable(this.sessionTrackerRef.get()).ifPresent(service -> service.recordInteraction((HttpServletRequest)request));
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

