/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.diagnostics.ipd.db;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.Query;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabasePoolDiagnosticProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DatabasePoolDiagnosticProvider.class);
    private static final MBeanServer MBEAN_SERVER = ManagementFactory.getPlatformMBeanServer();

    public @Nullable ConnectionPoolProps getConnectionPoolProps() {
        try {
            ObjectName name = (ObjectName)MBEAN_SERVER.queryNames(new ObjectName("com.zaxxer.hikari:*"), Query.isInstanceOf(Query.value("com.zaxxer.hikari.pool.HikariPool"))).stream().findFirst().get();
            Object idle = MBEAN_SERVER.getAttribute(name, "IdleConnections");
            Object active = MBEAN_SERVER.getAttribute(name, "ActiveConnections");
            return new ConnectionPoolProps(((Integer)idle).intValue(), ((Integer)active).intValue());
        }
        catch (Exception e) {
            LOG.debug("Couldn't get connection pool properties", (Throwable)e);
            return null;
        }
    }

    public static class ConnectionPoolProps {
        private final long idleConnections;
        private final long activeConnections;

        ConnectionPoolProps(long idleConnections, long activeConnections) {
            this.idleConnections = idleConnections;
            this.activeConnections = activeConnections;
        }

        long getIdleConnections() {
            return this.idleConnections;
        }

        long getActiveConnections() {
            return this.activeConnections;
        }
    }
}

