/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util.profiling;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.dmz.spaces.SpaceManagerInternal;
import com.atlassian.confluence.event.events.analytics.HttpRequestStats;
import com.atlassian.confluence.impl.sitemesh.DecoratorActionFactory;
import com.atlassian.confluence.impl.sitemesh.DecoratorTimings;
import com.atlassian.confluence.plugin.descriptor.web.WebInterfaceContext;
import com.atlassian.confluence.setup.sitemesh.SitemeshPageBodyRenderable;
import com.atlassian.confluence.setup.sitemesh.SitemeshPageHeadRenderable;
import com.atlassian.confluence.setup.struts.ConfluenceStrutsVelocityContext;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.struts.compat.ActionContext;
import com.atlassian.confluence.struts.compat.ServletActionContext;
import com.atlassian.confluence.themes.Theme;
import com.atlassian.confluence.themes.ThemeContext;
import com.atlassian.confluence.themes.ThemeManager;
import com.atlassian.confluence.util.MemoizingComponentReference;
import com.atlassian.confluence.util.profiling.VelocitySitemeshPage;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import com.atlassian.velocity.htmlsafe.HtmlFragment;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.opensymphony.module.sitemesh.Decorator;
import com.opensymphony.module.sitemesh.HTMLPage;
import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.module.sitemesh.RequestConstants;
import com.opensymphony.sitemesh.Content;
import com.opensymphony.sitemesh.compatability.Content2HTMLPage;
import com.opensymphony.sitemesh.webapp.SiteMeshWebAppContext;
import com.opensymphony.sitemesh.webapp.decorator.BaseWebAppDecorator;
import java.io.IOException;
import java.io.Writer;
import java.util.Optional;
import java.util.function.Supplier;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.views.velocity.VelocityManagerInterface;
import org.apache.velocity.context.Context;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.support.TransactionTemplate;

@Deprecated(forRemoval=true)
public class ConfluenceSitemeshDecorator
extends BaseWebAppDecorator {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceSitemeshDecorator.class);
    public static final String HTTP_REQUEST_ATTR_KEY_WEB_INTERFACE_CONTEXT = "atlas.webInterfaceContext";
    public static final boolean BUFFER_RESPONSE = Boolean.getBoolean("confluence.sitemesh.response.buffer");
    protected static final ErrorHandlingStrategy ERROR_SENDING_STRATEGY = new ErrorSendingErrorHandlingStrategy();
    protected static final ErrorHandlingStrategy ERROR_THROWING_STRATEGY = new ErrorThrowingErrorHandlingStrategy();
    public static final String CONFLUENCE_SITEMESH_DECORATOR_ATTRIBUTE = "com.atlassian.confluence.util.profiling.ConfluenceSitemeshDecorator";
    static final String SPACE_ID_KEY = "meta.spaceid";
    private final ResponseWritingStrategy writingStrategy;
    private final ThemeManager themeManager;
    private final Decorator decorator;
    private final SpaceManagerInternal spaceManager;
    private final VelocityManagerInterface velocityManager;
    private final Supplier<PlatformTransactionManager> platformTransactionManagerSupplier = MemoizingComponentReference.containerComponent((String)"transactionManager");

    ConfluenceSitemeshDecorator(ThemeManager themeManager, SpaceManagerInternal spaceManager, Decorator decorator, VelocityManagerInterface velocityManager) {
        this(themeManager, spaceManager, decorator, ERROR_SENDING_STRATEGY, velocityManager);
    }

    ConfluenceSitemeshDecorator(ThemeManager themeManager, SpaceManagerInternal spaceManager, Decorator decorator, ErrorHandlingStrategy errorHandlingStrategy, VelocityManagerInterface velocityManager) {
        this.themeManager = themeManager;
        this.decorator = decorator;
        this.writingStrategy = BUFFER_RESPONSE ? new StaticBufferedResponseWritingStrategy(errorHandlingStrategy) : new StreamingResponseWritingStrategy(errorHandlingStrategy);
        this.spaceManager = spaceManager;
        this.velocityManager = velocityManager;
    }

    private PlatformTransactionManager getPTManager() {
        return this.platformTransactionManagerSupplier.get();
    }

    protected void render(Content content, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, SiteMeshWebAppContext siteMeshWebAppContext) throws IOException, ServletException {
        request.setAttribute(CONFLUENCE_SITEMESH_DECORATOR_ATTRIBUTE, (Object)true);
        String profileName = "SiteMesh: applyDecorator: " + this.decorator.getName() + " (" + this.decorator.getPage() + ")";
        try (DecoratorTimings.DecoratorTimer timer = DecoratorTimings.newDecoratorTimer((Decorator)this.getDecorator(), (HttpServletRequest)request);
             Ticker ignored = Timers.start((String)profileName);){
            if (ContainerManager.isContainerSetup()) {
                new TransactionTemplate(this.getPTManager()).execute(status -> {
                    try {
                        this.renderInternal(content, request, response);
                        return null;
                    }
                    catch (Exception ex) {
                        Throwables.throwIfInstanceOf((Throwable)ex, RuntimeException.class);
                        throw new UncheckedExecutionException((Throwable)ex);
                    }
                });
            } else {
                this.renderInternal(content, request, response);
            }
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), IOException.class);
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), ServletException.class);
            throw e;
        }
        catch (TransactionException ex) {
            log.warn("TransactionException prevented transaction from committing whilst rendering the decorator, the cause is likely a previously logged exception: {}\nCause: {}", (Object)ex.getMessage(), (Object)(ex.getCause() != null ? ex.getCause().getMessage() : ""));
            log.debug("Full Details: ", (Throwable)ex);
        }
    }

    protected void renderInternal(Content content, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Content2HTMLPage page = new Content2HTMLPage(content, request);
        this.applyDecorator((Page)page, this.decorator, request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyDecorator(Page page, Decorator decorator, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Preconditions.checkState((ActionContext.getContext() != null ? 1 : 0) != 0, (Object)"Struts has not been initialized on this thread");
        HttpRequestStats.elapse((String)"sitemeshDecoratorApplyStarted");
        HttpServletRequest originalRequest = ServletActionContext.getRequest();
        HttpServletResponse originalResponse = ServletActionContext.getResponse();
        ServletActionContext.setRequest((HttpServletRequest)request);
        ServletActionContext.setResponse((HttpServletResponse)response);
        try {
            this.applyDecoratorUsingVelocity(request, page, response, decorator);
        }
        finally {
            ServletActionContext.setRequest((HttpServletRequest)originalRequest);
            ServletActionContext.setResponse((HttpServletResponse)originalResponse);
            HttpRequestStats.elapse((String)"sitemeshDecoratorApplyFinished");
        }
    }

    @VisibleForTesting
    Optional<Space> findSpaceForDecorating(@Nullable WebInterfaceContext webInterfaceContext, Page page) {
        Space space = Optional.ofNullable(webInterfaceContext).map(WebInterfaceContext::getSpace).orElse(null);
        if (space == null && this.spaceManager != null) {
            String spaceId = page.getProperty(SPACE_ID_KEY);
            space = Optional.ofNullable(spaceId).map(spaceIdString -> {
                try {
                    return Long.parseLong(spaceIdString);
                }
                catch (NumberFormatException nfe) {
                    log.warn("Invalid spaceId", (Throwable)nfe);
                    return null;
                }
            }).map(arg_0 -> ((SpaceManagerInternal)this.spaceManager).getSpace(arg_0)).orElse(null);
        }
        return Optional.ofNullable(space);
    }

    private void applyDecoratorUsingVelocity(HttpServletRequest request, Page page, HttpServletResponse response, Decorator decorator) throws ServletException, IOException {
        request.setAttribute(RequestConstants.PAGE, (Object)page);
        if (!response.isCommitted()) {
            response.setHeader("X-Accel-Buffering", "no");
        }
        WebInterfaceContext webInterfaceContext = (WebInterfaceContext)request.getAttribute(HTTP_REQUEST_ATTR_KEY_WEB_INTERFACE_CONTEXT);
        Optional<Space> space = this.findSpaceForDecorating(webInterfaceContext, page);
        ConfluenceActionSupport action = DecoratorActionFactory.createAction((WebInterfaceContext)webInterfaceContext, (Space)space.orElse(null));
        if (space.isPresent() && !ThemeContext.hasThemeContext((ServletRequest)request)) {
            ThemeContext.set((ServletRequest)request, (Space)space.get(), (Theme)this.getActiveTheme(space.get().getKey()), (Theme)this.getGlobalTheme());
        }
        Context context = this.constructVelocityContext(request, response, space.orElse(null), page, action);
        this.writingStrategy.renderToResponse(decorator, context, response);
        request.removeAttribute(RequestConstants.PAGE);
    }

    private Context constructVelocityContext(HttpServletRequest request, HttpServletResponse response, Space space, Page page, ConfluenceActionSupport action) {
        String spaceKey;
        Context context = this.velocityManager.createContext(ActionContext.getContext().getValueStack(), request, response);
        if (!context.containsKey((Object)"staticResourceUrlPrefix")) {
            context.put("staticResourceUrlPrefix", (Object)request.getContextPath());
        }
        context.put("action", (Object)action);
        context.put("helper", (Object)action.getHelper());
        context.put("sitemeshPage", (Object)page);
        context.put("title", (Object)page.getTitle());
        context.put("username", (Object)page.getProperty("page.username"));
        if (space != null) {
            context.put("space", (Object)space);
            spaceKey = space.getKey();
        } else {
            spaceKey = page.getProperty("page.spacekey");
        }
        context.put("spaceKey", (Object)spaceKey);
        context.put("theme", (Object)this.getActiveTheme(spaceKey));
        context.put("body", (Object)new SitemeshPageBodyRenderable(page));
        context.put("decorator", (Object)this.decorator);
        if (page instanceof HTMLPage) {
            HTMLPage htmlPage = (HTMLPage)page;
            context.put("head", (Object)new SitemeshPageHeadRenderable(htmlPage));
            context.put("sitemeshPage", (Object)new VelocitySitemeshPage((HTMLPage)page));
            context.put("title", (Object)new HtmlFragment((Object)page.getTitle()));
            if (context instanceof ConfluenceStrutsVelocityContext) {
                ConfluenceStrutsVelocityContext confluenceContext = (ConfluenceStrutsVelocityContext)context;
                confluenceContext.setOutputMimeType("text/html");
            }
        }
        return context;
    }

    private Theme getActiveTheme(String spaceKey) {
        return this.themeManager == null ? null : this.themeManager.getSpaceTheme(spaceKey);
    }

    private Theme getGlobalTheme() {
        return this.themeManager == null ? null : this.themeManager.getGlobalTheme();
    }

    protected Decorator getDecorator() {
        return this.decorator;
    }

    protected static interface ErrorHandlingStrategy {
        public void handleException(Exception var1, HttpServletResponse var2) throws ServletException, IOException;
    }

    private static final class StaticBufferedResponseWritingStrategy
    implements ResponseWritingStrategy {
        private final ErrorHandlingStrategy errorHandlingStrategy;

        private StaticBufferedResponseWritingStrategy(ErrorHandlingStrategy errorHandlingStrategy) {
            this.errorHandlingStrategy = errorHandlingStrategy;
        }

        @Override
        public void renderToResponse(Decorator decorator, Context context, HttpServletResponse response) throws ServletException, IOException {
            try {
                String template = VelocityUtils.getRenderedTemplateWithoutSwallowingErrors((String)decorator.getPage(), (Context)context);
                response.getWriter().write(template);
            }
            catch (Exception e) {
                this.errorHandlingStrategy.handleException(e, response);
            }
        }
    }

    private static final class StreamingResponseWritingStrategy
    implements ResponseWritingStrategy {
        private final ErrorHandlingStrategy errorHandlingStrategy;

        private StreamingResponseWritingStrategy(ErrorHandlingStrategy errorHandlingStrategy) {
            this.errorHandlingStrategy = errorHandlingStrategy;
        }

        @Override
        public void renderToResponse(Decorator decorator, Context context, HttpServletResponse response) throws ServletException, IOException {
            try {
                VelocityUtils.renderTemplateWithoutSwallowingErrors((String)decorator.getPage(), (Context)context, (Writer)response.getWriter());
            }
            catch (Exception e) {
                if (response.isCommitted()) {
                    response.getWriter().printf("Error occurred during template rendering. Contact your administrator for assistance.", new Object[0]);
                    log.error("Error occurred rendering template: " + decorator.getPage(), (Throwable)e);
                }
                this.errorHandlingStrategy.handleException(e, response);
            }
        }
    }

    private static interface ResponseWritingStrategy {
        public void renderToResponse(Decorator var1, Context var2, HttpServletResponse var3) throws ServletException, IOException;
    }

    private static final class ErrorSendingErrorHandlingStrategy
    implements ErrorHandlingStrategy {
        private ErrorSendingErrorHandlingStrategy() {
        }

        @Override
        public void handleException(Exception e, HttpServletResponse response) throws ServletException, IOException {
            response.sendError(500);
            throw new ServletException((Throwable)e);
        }
    }

    private static final class ErrorThrowingErrorHandlingStrategy
    implements ErrorHandlingStrategy {
        private ErrorThrowingErrorHandlingStrategy() {
        }

        @Override
        public void handleException(Exception e, HttpServletResponse response) throws ServletException, IOException {
            throw new ServletException((Throwable)e);
        }
    }
}

