/*
 * Decompiled with CFR 0.152.
 */
package bucket.core.persistence.hibernate;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.cache.spi.access.EntityRegionAccessStrategy;
import org.hibernate.cache.spi.access.NaturalIdRegionAccessStrategy;
import org.hibernate.cfg.Configuration;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.SingleTableEntityPersister;
import org.hibernate.persister.internal.StandardPersisterClassResolver;
import org.hibernate.persister.spi.PersisterClassResolver;
import org.hibernate.persister.spi.PersisterCreationContext;
import org.hibernate.service.Service;

@Deprecated
public class MemoryOptimizedSingleTableEntityPersister
extends SingleTableEntityPersister {
    private static final EnumSet<LockMode> SELDOM_USED_LOADER_TYPES = EnumSet.of(LockMode.UPGRADE, new LockMode[]{LockMode.UPGRADE_NOWAIT, LockMode.OPTIMISTIC, LockMode.OPTIMISTIC_FORCE_INCREMENT, LockMode.PESSIMISTIC_FORCE_INCREMENT, LockMode.PESSIMISTIC_READ, LockMode.PESSIMISTIC_WRITE, LockMode.UPGRADE_SKIPLOCKED, LockMode.FORCE});
    private Map loaders = this.createInterceptedLoadersMap();

    public MemoryOptimizedSingleTableEntityPersister(PersistentClass persistentClass, EntityRegionAccessStrategy cache, NaturalIdRegionAccessStrategy naturalIdRegionAccessStrategy, PersisterCreationContext creationContext) throws HibernateException {
        super(persistentClass, cache, naturalIdRegionAccessStrategy, creationContext);
    }

    private Map createInterceptedLoadersMap() {
        return new HashMap(){

            @Override
            public boolean containsKey(Object key) {
                return super.containsKey(key) || SELDOM_USED_LOADER_TYPES.contains(key);
            }

            @Override
            public Object get(Object key) {
                Object loader = super.get(key);
                if (loader != null) {
                    return loader;
                }
                if (SELDOM_USED_LOADER_TYPES.contains(key)) {
                    MemoryOptimizedSingleTableEntityPersister.super.createLoaders();
                    return super.get(key);
                }
                return null;
            }
        };
    }

    public static void configure(Configuration config) {
        config.getStandardServiceRegistryBuilder().addService(PersisterClassResolver.class, (Service)new StandardPersisterClassResolver(){

            public Class<? extends EntityPersister> singleTableEntityPersister() {
                return MemoryOptimizedSingleTableEntityPersister.class;
            }
        });
    }

    protected Map getLoaders() {
        return this.loaders;
    }

    protected void createLoaders() {
        super.createLoaders();
        this.removeSeldomUsedUniqueEntityLoaders();
    }

    private void removeSeldomUsedUniqueEntityLoaders() {
        Map loaders = this.getLoaders();
        for (LockMode lockMode : SELDOM_USED_LOADER_TYPES) {
            loaders.remove(lockMode);
        }
    }
}

