/*
 * Decompiled with CFR 0.152.
 */
package bucket.user.propertyset;

import com.atlassian.cache.Cache;
import com.opensymphony.module.propertyset.PropertyException;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetSchema;
import com.opensymphony.util.DataUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import org.w3c.dom.Document;

public class CacheAwarePropertySet
implements PropertySet,
Serializable {
    public static final String CACHE_ARGUMENT = "Cache";
    public static final String PROPERTY_SET_KEY_ARGUMENT = "PropertySetKey";
    public static final String DECORATED_PROPERTY_SET_ARGUMENT = "PropertySet";
    private Cache cache;
    private String cacheKeyPrefix;
    private PropertySet delegatePropertySet;

    public void init(Map config, Map args) {
        this.cache = (Cache)args.get(CACHE_ARGUMENT);
        this.cacheKeyPrefix = (String)args.get(PROPERTY_SET_KEY_ARGUMENT);
        this.delegatePropertySet = (PropertySet)args.get(DECORATED_PROPERTY_SET_ARGUMENT);
    }

    public void setAsActualType(String key, Object value) throws PropertyException {
        if (value instanceof Boolean) {
            this.setBoolean(key, DataUtil.getBoolean((Boolean)((Boolean)value)));
        } else if (value instanceof Integer) {
            this.setInt(key, DataUtil.getInt((Integer)((Integer)value)));
        } else if (value instanceof Long) {
            this.setLong(key, DataUtil.getLong((Long)((Long)value)));
        } else if (value instanceof Double) {
            this.setDouble(key, DataUtil.getDouble((Double)((Double)value)));
        } else if (value instanceof String) {
            this.setString(key, (String)value);
        } else if (value instanceof Date) {
            this.setDate(key, (Date)value);
        } else if (value instanceof Document) {
            this.setXML(key, (Document)value);
        } else if (value instanceof byte[]) {
            this.setData(key, (byte[])value);
        } else if (value instanceof Properties) {
            this.setProperties(key, (Properties)value);
        } else {
            this.setObject(key, value);
        }
    }

    public Object getAsActualType(String key) throws PropertyException {
        int type = this.getType(key);
        Object value = null;
        switch (type) {
            case 1: {
                value = this.getBoolean(key);
                break;
            }
            case 2: {
                value = this.getInt(key);
                break;
            }
            case 3: {
                value = this.getLong(key);
                break;
            }
            case 4: {
                value = this.getDouble(key);
                break;
            }
            case 5: {
                value = this.getString(key);
                break;
            }
            case 7: {
                value = this.getDate(key);
                break;
            }
            case 9: {
                value = this.getXML(key);
                break;
            }
            case 10: {
                value = this.getData(key);
                break;
            }
            case 11: {
                value = this.getProperties(key);
                break;
            }
            case 8: {
                value = this.getObject(key);
            }
        }
        return value;
    }

    private String buildCacheKey(String key) {
        return this.cacheKeyPrefix + "." + key;
    }

    private void putIntoCache(String key, Object value) {
        Object valueToCache = value == null ? Null.NULL : value;
        this.cache.put((Object)this.buildCacheKey(key), valueToCache);
    }

    private Object getFromCache(String key) {
        Object cachedValue = this.cache.get((Object)this.buildCacheKey(key));
        return cachedValue;
    }

    private boolean cacheContainsKey(String key) {
        return this.cache.containsKey((Object)this.buildCacheKey(key));
    }

    public void setBoolean(String key, boolean value) throws PropertyException {
        this.delegatePropertySet.setBoolean(key, value);
        this.putIntoCache(key, value);
    }

    public boolean getBoolean(String key) throws PropertyException {
        return this.getFromCache(key, () -> this.delegatePropertySet.getBoolean(key), false);
    }

    public void setData(String key, byte[] value) throws PropertyException {
        this.delegatePropertySet.setData(key, value);
        this.putIntoCache(key, value);
    }

    public byte[] getData(String key) throws PropertyException {
        return this.getFromCache(key, () -> this.delegatePropertySet.getData(key), null);
    }

    public void setDate(String key, Date value) throws PropertyException {
        this.delegatePropertySet.setDate(key, value);
        this.putIntoCache(key, value);
    }

    public Date getDate(String key) throws PropertyException {
        return this.getFromCache(key, () -> this.delegatePropertySet.getDate(key), null);
    }

    public void setDouble(String key, double value) throws PropertyException {
        this.delegatePropertySet.setDouble(key, value);
        this.putIntoCache(key, value);
    }

    public double getDouble(String key) throws PropertyException {
        return (Double)((Object)this.getFromCache(key, () -> this.delegatePropertySet.getDouble(key), 0));
    }

    public void setInt(String key, int value) throws PropertyException {
        this.delegatePropertySet.setInt(key, value);
        this.putIntoCache(key, value);
    }

    public int getInt(String key) throws PropertyException {
        return this.getFromCache(key, () -> this.delegatePropertySet.getInt(key), 0);
    }

    public Collection getKeys() throws PropertyException {
        return this.delegatePropertySet.getKeys();
    }

    public Collection getKeys(int type) throws PropertyException {
        return this.delegatePropertySet.getKeys(type);
    }

    public Collection getKeys(String prefix) throws PropertyException {
        return this.delegatePropertySet.getKeys(prefix);
    }

    public Collection getKeys(String prefix, int type) throws PropertyException {
        return this.delegatePropertySet.getKeys(prefix, type);
    }

    public void setLong(String key, long value) throws PropertyException {
        this.delegatePropertySet.setLong(key, value);
        this.putIntoCache(key, value);
    }

    public long getLong(String key) throws PropertyException {
        return (Long)((Object)this.getFromCache(key, () -> this.delegatePropertySet.getLong(key), 0));
    }

    public void setObject(String key, Object value) throws PropertyException {
        this.delegatePropertySet.setObject(key, value);
        this.putIntoCache(key, value);
    }

    public Object getObject(String key) throws PropertyException {
        return this.getFromCache(key, () -> this.delegatePropertySet.getObject(key), null);
    }

    public void setProperties(String key, Properties value) throws PropertyException {
        this.delegatePropertySet.setProperties(key, value);
        this.putIntoCache(key, value);
    }

    public Properties getProperties(String key) throws PropertyException {
        return this.getFromCache(key, () -> this.delegatePropertySet.getProperties(key), null);
    }

    public void setSchema(PropertySetSchema schema) throws PropertyException {
        this.delegatePropertySet.setSchema(schema);
    }

    public PropertySetSchema getSchema() throws PropertyException {
        return this.delegatePropertySet.getSchema();
    }

    public boolean isSettable(String property) {
        return this.delegatePropertySet.isSettable(property);
    }

    public void setString(String key, String value) throws PropertyException {
        this.delegatePropertySet.setString(key, value);
        this.putIntoCache(key, value);
    }

    public String getString(String key) throws PropertyException {
        return this.getFromCache(key, () -> this.delegatePropertySet.getString(key), null);
    }

    public void setText(String key, String value) throws PropertyException {
        this.delegatePropertySet.setText(key, value);
        this.putIntoCache(key, value);
    }

    public String getText(String key) throws PropertyException {
        return this.getFromCache(key, () -> this.delegatePropertySet.getText(key), null);
    }

    public int getType(String key) throws PropertyException {
        return this.delegatePropertySet.getType(key);
    }

    public void setXML(String key, Document value) throws PropertyException {
        this.delegatePropertySet.setXML(key, value);
        this.putIntoCache(key, value);
    }

    public Document getXML(String key) throws PropertyException {
        return this.getFromCache(key, () -> this.delegatePropertySet.getXML(key), null);
    }

    private <T> T getFromCache(String key, Supplier<T> delegateValue, T nullValue) {
        Object result = this.getFromCache(key);
        if (result == Null.NULL) {
            result = nullValue;
        } else if (result == null) {
            result = delegateValue.get();
            this.putIntoCache(key, result);
        }
        return (T)result;
    }

    public boolean exists(String key) throws PropertyException {
        Object value;
        if (!this.cacheContainsKey(key)) {
            if (this.delegatePropertySet.exists(key)) {
                value = this.delegatePropertySet.getAsActualType(key);
                this.putIntoCache(key, value);
            } else {
                this.putIntoCache(key, null);
            }
        }
        return (value = this.getFromCache(key)) != null && value != Null.NULL;
    }

    public void remove(String key) throws PropertyException {
        this.cache.remove((Object)this.buildCacheKey(key));
        this.delegatePropertySet.remove(key);
    }

    public boolean supportsType(int type) {
        return this.delegatePropertySet.supportsType(type);
    }

    public boolean supportsTypes() {
        return this.delegatePropertySet.supportsTypes();
    }

    static enum Null {
        NULL;

    }
}

