/*
 * Decompiled with CFR 0.152.
 */
package bucket.core.persistence.hibernate;

import bucket.core.persistence.EntityObjectQueue;
import bucket.core.persistence.hibernate.HibernateHandle;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate.SessionFactoryUtils;

public class HibernateEntityObjectQueue
implements EntityObjectQueue {
    @Deprecated
    public static final org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(HibernateEntityObjectQueue.class);
    private static final Logger log2 = LoggerFactory.getLogger(HibernateEntityObjectQueue.class);
    private List handles;
    private SessionFactory sessionFactory;

    public HibernateEntityObjectQueue(List handles, SessionFactory sessionFactory) throws HibernateException {
        this.handles = handles;
        this.sessionFactory = sessionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getNextObjects() {
        ArrayList<Long> idsToCollect = new ArrayList<Long>(10);
        String className = null;
        List list = this.handles;
        synchronized (list) {
            Iterator it = this.handles.iterator();
            while (it.hasNext() && idsToCollect.size() < 10) {
                HibernateHandle handle = (HibernateHandle)it.next();
                if (className != null && !className.equals(handle.getClassName())) continue;
                log2.debug("Collecting: {}", (Object)handle);
                className = handle.getClassName();
                idsToCollect.add(new Long(handle.getId()));
                it.remove();
            }
        }
        try {
            if (idsToCollect.size() > 0) {
                return this.getObjects(idsToCollect, className);
            }
        }
        catch (HibernateException e) {
            log2.error("Unable to get objects", (Throwable)e);
        }
        return new ArrayList(0);
    }

    @Override
    public void clearCaches() {
        this.getSession().clear();
    }

    @Override
    public void close() {
    }

    private List getObjects(List idsToCollect, String className) throws HibernateException {
        return this.getSession().find("from " + className + " s where s.id = " + TextUtils.join((String)" or s.id = ", (Collection)idsToCollect));
    }

    private Session getSession() {
        return SessionFactoryUtils.getSession((SessionFactory)this.sessionFactory, (boolean)false);
    }
}

