/*
 * Decompiled with CFR 0.152.
 */
package bucket.core.persistence.hibernate.schema;

import bucket.core.persistence.hibernate.MappingResources;
import com.atlassian.config.ConfigurationException;
import com.atlassian.config.db.HibernateConfig;
import com.atlassian.util.concurrent.LazyReference;
import com.atlassian.util.concurrent.Supplier;
import com.atlassian.util.concurrent.Suppliers;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Properties;
import javax.annotation.concurrent.NotThreadSafe;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.cfg.Configuration;
import net.sf.hibernate.tool.hbm2ddl.SchemaExport;
import net.sf.hibernate.tool.hbm2ddl.SchemaUpdate;

@NotThreadSafe
public class SchemaHelper {
    public static final String COMPONENT_REFERENCE = "schemaHelper";
    private Supplier<Configuration> configuration = new LazyReference<Configuration>(){

        protected Configuration create() throws Exception {
            Preconditions.checkState((SchemaHelper.this.hibernateProperties != null ? 1 : 0) != 0, (Object)"usage of deprecated ctor, either setHibernateProperties or setHibernateConfig should have been set");
            Configuration configuration = new Configuration();
            configuration.setProperties((Properties)SchemaHelper.this.hibernateProperties.get());
            for (String mappingResource : SchemaHelper.this.mappingResources) {
                configuration.addResource(mappingResource, Thread.currentThread().getContextClassLoader());
            }
            return configuration;
        }
    };
    private Iterable<String> mappingResources;
    private Supplier<Properties> hibernateProperties;

    @Deprecated
    public SchemaHelper() {
    }

    public SchemaHelper(Iterable<String> mappingResources, HibernateConfig hibernateConfig) {
        this.mappingResources = mappingResources;
        this.setHibernateConfig(hibernateConfig);
    }

    public SchemaHelper(Iterable<String> mappingResources, Properties hibernateProperties) {
        this.mappingResources = mappingResources;
        this.setHibernateProperties(hibernateProperties);
    }

    @Deprecated
    public void setHibernateProperties(Properties hibernateConfigProperties) {
        this.hibernateProperties = Suppliers.memoize((Object)hibernateConfigProperties);
    }

    @Deprecated
    public void setHibernateConfig(final HibernateConfig hibernateConfig) {
        this.hibernateProperties = new Supplier<Properties>(){

            public Properties get() {
                return hibernateConfig.getHibernateProperties();
            }
        };
    }

    public Configuration getConfiguration() throws MappingException {
        return (Configuration)this.configuration.get();
    }

    @Deprecated
    public void setConfiguration(Configuration configuration) {
        this.configuration = Suppliers.memoize((Object)configuration);
    }

    @Deprecated
    public MappingResources getMappingResources() {
        MappingResources mappingResources = new MappingResources();
        mappingResources.setMappings(Lists.newArrayList(this.mappingResources));
        return mappingResources;
    }

    @Deprecated
    public void setMappingResources(MappingResources mappings) {
        this.addMappingResources(mappings.getMappings());
    }

    @Deprecated
    public void addMappingResources(List<String> mappings) {
        mappings.addAll(mappings);
    }

    public void recreateDatabase() throws ConfigurationException {
        this.createTables();
    }

    public void dropTables() throws ConfigurationException {
        try {
            new SchemaExport(this.getConfiguration()).drop(true, true);
        }
        catch (Exception e) {
            throw new ConfigurationException("Cannot update schema", (Throwable)e);
        }
    }

    public void createTables() throws ConfigurationException {
        try {
            new SchemaExport(this.getConfiguration()).create(true, true);
        }
        catch (Exception e) {
            throw new ConfigurationException("Cannot update schema", (Throwable)e);
        }
    }

    public void updateSchemaIfNeeded() throws ConfigurationException {
        this.updateSchemaIfNeeded(false);
    }

    public void validateSchemaUpdateIfNeeded() throws ConfigurationException {
        try {
            boolean showDDL = false;
            boolean doUpdate = false;
            boolean abortOnFail = true;
            new SchemaUpdate(this.getConfiguration()).execute(showDDL, doUpdate, abortOnFail);
        }
        catch (Exception e) {
            throw new ConfigurationException("Cannot update schema", (Throwable)e);
        }
    }

    public void updateSchemaIfNeeded(boolean showDDL) throws ConfigurationException {
        try {
            new SchemaUpdate(this.getConfiguration()).execute(showDDL, true, true);
        }
        catch (Exception e) {
            throw new ConfigurationException("Cannot update schema", (Throwable)e);
        }
    }

    public Iterable<String> getMappingResourcesView() {
        return this.mappingResources;
    }
}

