/*
 * Decompiled with CFR 0.152.
 */
package bucket.core.persistence.hibernate;

import bucket.core.persistence.hibernate.MappingResources;
import com.atlassian.cache.CacheManager;
import com.atlassian.config.db.HibernateConfig;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.cfg.Configuration;
import org.springframework.orm.hibernate.LocalSessionFactoryBean;

public class ConfigurableLocalSessionFactoryBean
extends LocalSessionFactoryBean {
    private CacheManager cacheManager;
    private Iterable<String> mappingResources;
    private HibernateConfig hibernateConfig;

    public Configuration newConfiguration() throws HibernateException {
        Configuration config = new Configuration();
        config.addProperties(this.hibernateConfig.getHibernateProperties());
        this.setConfigLocation(null);
        super.setMappingResources((String[])Iterables.toArray(this.mappingResources, String.class));
        return config;
    }

    @Deprecated
    public MappingResources getMappingResources() {
        MappingResources mappingResources = new MappingResources();
        mappingResources.setMappings((List)ImmutableList.of(this.mappingResources));
        return mappingResources;
    }

    public void setHibernateConfig(HibernateConfig hibernateConfig) {
        this.hibernateConfig = hibernateConfig;
    }

    public void setMappingResources(MappingResources mappingResources) {
        this.setCurrentMappingResources(mappingResources.getMappings());
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setCurrentMappingResources(Iterable<String> mappingResources) {
        this.mappingResources = mappingResources;
    }

    public Iterable<String> getCurrentMappingResources() {
        return this.mappingResources;
    }
}

