/*
 * Decompiled with CFR 0.152.
 */
package bucket.user.providers;

import bucket.user.providers.ChainedProfileProvider;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheManager;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.cache.CacheFactoryAware;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetManager;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingProfileProvider
extends ChainedProfileProvider
implements CacheFactoryAware {
    public static final String CACHE_KEY_PROFILE_PROVIDER_HANDLES = CachingProfileProvider.class.getName() + ".handles()";
    public static final String CACHE_KEY_PROFILE_PROVIDER_PROPERTY_SETS = CachingProfileProvider.class.getName() + ".getPropertySet()";
    public static final String CACHE_KEY_PROPERTY_SETS_REFERENCES_CACHE = CachingProfileProvider.class.getName() + ".references()";
    private static Logger log = LoggerFactory.getLogger(CachingProfileProvider.class);
    private CacheFactory cacheFactory;
    private Cache<String, Boolean> handlesCache;
    private Cache<String, Object> propertySetValuesCache;
    private Cache<String, PropertySet> propertySetReferencesCache;

    @Override
    public boolean init(Properties properties) {
        boolean result = super.init(properties);
        if (ContainerManager.isContainerSetup()) {
            if (ContainerManager.getComponent((String)"cacheFactory") != null) {
                this.cacheFactory = (CacheFactory)ContainerManager.getComponent((String)"cacheFactory");
            }
            if (this.cacheFactory == null && ContainerManager.getComponent((String)"cacheManager") != null) {
                this.cacheFactory = (CacheManager)ContainerManager.getComponent((String)"cacheManager");
            }
            this.initCaches();
        }
        return result;
    }

    @Override
    public boolean handles(String name) {
        String lowerCaseName = this.toLowerCase(name);
        try {
            Boolean element = (Boolean)this.handlesCache.get((Object)lowerCaseName);
            if (element != null) {
                log.debug("Found cached handles() lookup for {}", (Object)lowerCaseName);
                return element;
            }
        }
        catch (Exception e) {
            log.error("Error accessing handlesCache", (Throwable)e);
        }
        Boolean result = super.handles(name);
        this.handlesCache.put((Object)lowerCaseName, (Object)result);
        log.debug("Caching handles() result for {}", (Object)lowerCaseName);
        return result;
    }

    private String toLowerCase(String name) {
        return Strings.nullToEmpty((String)name).toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean create(String name) {
        Cache<String, Boolean> cache = this.handlesCache;
        synchronized (cache) {
            try {
                this.handlesCache.remove((Object)name);
                this.propertySetReferencesCache.remove((Object)name);
            }
            catch (Exception e) {
                log.error(e.toString(), (Throwable)e);
            }
            return super.create(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(String name) {
        Cache<String, Boolean> cache = this.handlesCache;
        synchronized (cache) {
            try {
                this.handlesCache.remove((Object)name);
                this.propertySetReferencesCache.remove((Object)name);
            }
            catch (Exception e) {
                log.error(e.toString(), (Throwable)e);
            }
            return super.remove(name);
        }
    }

    @Override
    public void flushCaches() {
        try {
            this.handlesCache.removeAll();
            this.propertySetReferencesCache.removeAll();
        }
        catch (Exception e) {
            log.error(e.toString(), (Throwable)e);
        }
        super.flushCaches();
    }

    @Override
    public PropertySet getPropertySet(String name) {
        String propertySetKey = this.toLowerCase(name);
        PropertySet existingPropertySet = (PropertySet)this.propertySetReferencesCache.get((Object)propertySetKey);
        if (null == existingPropertySet) {
            PropertySet ps = super.getPropertySet(name);
            ImmutableMap initParams = ImmutableMap.of((Object)"Cache", this.propertySetValuesCache, (Object)"PropertySetKey", (Object)propertySetKey, (Object)"PropertySet", (Object)ps);
            PropertySet cachedPs = PropertySetManager.getInstance((String)"cached", (Map)initParams);
            this.propertySetReferencesCache.put((Object)propertySetKey, (Object)cachedPs);
            return cachedPs;
        }
        return existingPropertySet;
    }

    public void setCacheFactory(CacheFactory cacheFactory) {
        this.cacheFactory = cacheFactory;
        this.initCaches();
    }

    private void initCaches() {
        this.handlesCache = this.cacheFactory.getCache(CACHE_KEY_PROFILE_PROVIDER_HANDLES);
        this.propertySetValuesCache = this.cacheFactory.getCache(CACHE_KEY_PROFILE_PROVIDER_PROPERTY_SETS);
        this.propertySetReferencesCache = this.cacheFactory.getCache(CACHE_KEY_PROPERTY_SETS_REFERENCES_CACHE);
    }
}

