/*
 * Decompiled with CFR 0.152.
 */
package bucket.user.providers;

import bucket.user.providers.ChainedProfileProvider;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheManager;
import com.atlassian.core.exception.InfrastructureException;
import com.atlassian.core.propertyset.CachingPropertySet;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.cache.CacheFactoryAware;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetManager;
import com.opensymphony.util.TextUtils;
import java.util.HashMap;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingProfileProvider
extends ChainedProfileProvider
implements CacheFactoryAware {
    public static final String CACHE_KEY_PROFILE_PROVIDER_HANDLES = CachingProfileProvider.class.getName() + ".handles()";
    public static final String CACHE_KEY_PROFILE_PROVIDER_PROPERTYSETS = CachingProfileProvider.class.getName() + ".getPropertySet()";
    private static Logger log = LoggerFactory.getLogger(CachingProfileProvider.class);
    private Cache handlesCache;
    private Cache propertySetsCache;
    private CacheFactory cacheFactory;

    @Override
    public boolean init(Properties properties) {
        boolean result = super.init(properties);
        if (ContainerManager.isContainerSetup()) {
            if (ContainerManager.getComponent((String)"cacheFactory") != null) {
                this.cacheFactory = (CacheFactory)ContainerManager.getComponent((String)"cacheFactory");
            }
            if (this.cacheFactory == null && ContainerManager.getComponent((String)"cacheManager") != null) {
                this.cacheFactory = (CacheManager)ContainerManager.getComponent((String)"cacheManager");
            }
            this.initCaches();
        }
        return result;
    }

    @Override
    public boolean handles(String name) {
        String lowercasedName = TextUtils.noNull((String)name).toLowerCase();
        try {
            Object element = this.handlesCache.get((Object)lowercasedName);
            if (element != null) {
                Boolean result = (Boolean)element;
                if (log.isDebugEnabled()) {
                    log.debug("Found cached handles() lookup for " + lowercasedName);
                }
                return result;
            }
        }
        catch (Exception e) {
            log.error("Error accessing handlesCache:" + e, (Throwable)e);
        }
        boolean result = super.handles(name);
        this.handlesCache.put((Object)lowercasedName, (Object)result);
        if (log.isDebugEnabled()) {
            log.debug("Caching handles() result for " + lowercasedName);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean create(String name) {
        Cache cache = this.handlesCache;
        synchronized (cache) {
            try {
                this.handlesCache.remove((Object)name);
                this.propertySetsCache.remove((Object)name);
            }
            catch (Exception e) {
                log.error(e.toString(), (Throwable)e);
            }
            return super.create(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(String name) {
        Cache cache = this.handlesCache;
        synchronized (cache) {
            try {
                this.handlesCache.remove((Object)name);
                this.propertySetsCache.remove((Object)name);
            }
            catch (Exception e) {
                log.error(e.toString(), (Throwable)e);
            }
            return super.remove(name);
        }
    }

    @Override
    public void flushCaches() {
        try {
            this.handlesCache.removeAll();
            this.propertySetsCache.removeAll();
        }
        catch (Exception e) {
            log.error(e.toString(), (Throwable)e);
        }
        super.flushCaches();
    }

    @Override
    public PropertySet getPropertySet(String name) {
        String lowercasedName = TextUtils.noNull((String)name).toLowerCase();
        Object element = this.propertySetsCache.get((Object)lowercasedName);
        if (element != null) {
            return (CachingPropertySet)element;
        }
        PropertySet ps = super.getPropertySet(name);
        HashMap<String, PropertySet> initParams = new HashMap<String, PropertySet>(2);
        initParams.put("PropertySet", ps);
        PropertySet cachedPs = PropertySetManager.getInstance((String)"cached", initParams);
        this.propertySetsCache.put((Object)lowercasedName, (Object)cachedPs);
        return cachedPs;
    }

    public void setCacheFactory(CacheFactory cacheFactory) {
        this.cacheFactory = cacheFactory;
        this.initCaches();
    }

    private void initCaches() {
        if (this.cacheFactory != null) {
            this.handlesCache = this.cacheFactory.getCache(CACHE_KEY_PROFILE_PROVIDER_HANDLES);
            if (this.handlesCache == null) {
                throw new InfrastructureException("Could not find a handles cache - check ehcache.xml for : " + CACHE_KEY_PROFILE_PROVIDER_HANDLES);
            }
            this.propertySetsCache = this.cacheFactory.getCache(CACHE_KEY_PROFILE_PROVIDER_PROPERTYSETS);
            if (this.propertySetsCache == null) {
                throw new InfrastructureException("Could not find a property sets cache - check ehcache.xml for : " + CACHE_KEY_PROFILE_PROVIDER_PROPERTYSETS);
            }
        }
    }
}

