/*
 * Decompiled with CFR 0.152.
 */
package bucket.user;

import bucket.user.UserAccessor;
import com.atlassian.core.exception.InfrastructureException;
import com.atlassian.core.user.preferences.UserPreferences;
import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.atlassian.user.configuration.RepositoryAccessor;
import com.atlassian.user.impl.DefaultUser;
import com.atlassian.user.properties.PropertySetFactory;
import com.atlassian.user.repository.RepositoryIdentifier;
import com.atlassian.user.search.DefaultSearchResult;
import com.atlassian.user.search.SearchResult;
import com.atlassian.user.search.page.DefaultPager;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.search.query.EmailTermQuery;
import com.atlassian.user.search.query.EntityQueryParser;
import com.atlassian.user.search.query.Query;
import com.atlassian.user.search.query.QueryContext;
import com.atlassian.user.security.authentication.Authenticator;
import com.atlassian.user.security.password.Credential;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.util.TextUtils;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultUserAccessor
implements UserAccessor {
    private static final Logger log = LoggerFactory.getLogger(DefaultUserAccessor.class);
    public Group defaultGroup;
    public final String DEFAULT_GROUP_NAME = "users";
    private final RepositoryAccessor repositoryAccessor;

    protected DefaultUserAccessor(RepositoryAccessor repositoryAccessor) {
        this.repositoryAccessor = repositoryAccessor;
    }

    @Override
    public RepositoryIdentifier getRepository(Entity entity) throws EntityException {
        return this.repositoryAccessor.getIdentifier();
    }

    @Override
    public User addUser(String username, String password, String email, String fullname, String[] groups) {
        User user;
        try {
            user = this.addUser(username, password, email, fullname);
            if (groups != null) {
                for (String groupName : groups) {
                    Group group = this.getGroupCreateIfNecessary(groupName);
                    this.getGroupManager().addMembership(group, user);
                }
            }
        }
        catch (EntityException e) {
            throw new InfrastructureException((Throwable)e);
        }
        return user;
    }

    @Override
    public User addUser(String username, String password, String email, String fullname) {
        try {
            DefaultUser userTemplate = new DefaultUser(username.toLowerCase(), fullname, email);
            return this.getUserManager().createUser((User)userTemplate, Credential.unencrypted((String)password));
        }
        catch (EntityException e) {
            throw new InfrastructureException((Throwable)e);
        }
    }

    @Override
    public User createUser(User userTemplate, Credential credential) {
        try {
            return this.getUserManager().createUser(userTemplate, credential);
        }
        catch (EntityException e) {
            throw new InfrastructureException((Throwable)e);
        }
    }

    @Override
    public Pager<String> getUserNames() {
        Pager pager = null;
        try {
            pager = this.getUserManager().getUserNames();
        }
        catch (EntityException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return pager;
    }

    @Override
    public Pager<User> getUsers() {
        Pager pager = null;
        try {
            pager = this.getUserManager().getUsers();
        }
        catch (EntityException e) {
            log.error("Error in getUsers():" + e.getMessage(), (Throwable)e);
        }
        return pager;
    }

    @Override
    public User getUser(String name) {
        if (!TextUtils.stringSet((String)name)) {
            return null;
        }
        User user = null;
        try {
            user = this.getUserManager().getUser(name);
        }
        catch (EntityException e) {
            try {
                user = this.getUserManager().getUser(name.toLowerCase());
            }
            catch (EntityException e1) {
                log.error("Error in getUser():" + e1.getMessage(), (Throwable)e1);
            }
        }
        return user;
    }

    @Override
    public Pager<Group> getGroups() {
        Pager pager = null;
        try {
            pager = this.getGroupManager().getGroups();
        }
        catch (EntityException e) {
            log.error("Error in getGroups():" + e.getMessage(), (Throwable)e);
        }
        return pager;
    }

    @Override
    public Group addGroup(String name) {
        if (!TextUtils.stringSet((String)name)) {
            throw new IllegalArgumentException("Invalid group name specified.");
        }
        try {
            return this.getGroupManager().createGroup(name.toLowerCase());
        }
        catch (EntityException e) {
            throw new InfrastructureException(e.getMessage());
        }
    }

    @Override
    public void removeGroup(Group group) {
        try {
            this.getGroupManager().removeGroup(group);
        }
        catch (EntityException e) {
            throw new InfrastructureException(e.getMessage());
        }
    }

    @Override
    public void removeUser(User user) {
        try {
            this.getUserManager().removeUser(user);
        }
        catch (EntityException e) {
            throw new InfrastructureException(e.getMessage());
        }
    }

    @Override
    public void saveUser(User user) {
        try {
            this.getUserManager().saveUser(user);
        }
        catch (EntityException e) {
            throw new InfrastructureException(e.getMessage());
        }
    }

    @Override
    public SearchResult<User> findUsers(Query<User> query) throws EntityException {
        return this.getEntityQueryParser().findUsers(query);
    }

    public SearchResult<Group> findGroups(Query<Group> query) throws EntityException {
        return this.getEntityQueryParser().findGroups(query);
    }

    public SearchResult<User> findUsers(Query<User> query, QueryContext context) throws EntityException {
        return this.getEntityQueryParser().findUsers(query);
    }

    public SearchResult<Group> findGroups(Query<Group> query, QueryContext context) throws EntityException {
        return this.getEntityQueryParser().findGroups(query);
    }

    @Override
    public SearchResult getUsersByEmail(String email) {
        if (!TextUtils.stringSet((String)email)) {
            return new DefaultSearchResult();
        }
        SearchResult results = null;
        EmailTermQuery emailQuery = new EmailTermQuery(email);
        try {
            results = this.getEntityQueryParser().findUsers((Query)emailQuery);
        }
        catch (EntityException e) {
            log.error(e.getMessage());
        }
        return results;
    }

    @Override
    public Group getGroup(String name) {
        if (!TextUtils.stringSet((String)name)) {
            return null;
        }
        Group group = null;
        try {
            group = this.getGroupManager().getGroup(name);
        }
        catch (EntityException e) {
            log.error(e.getMessage());
        }
        return group;
    }

    @Override
    public Group getGroupCreateIfNecessary(String name) {
        Group group;
        if (!TextUtils.stringSet((String)name)) {
            throw new IllegalArgumentException("Invalid group name specified");
        }
        try {
            group = this.getGroupManager().getGroup(name);
            if (group == null) {
                group = this.getGroupManager().createGroup(name);
            }
        }
        catch (EntityException e) {
            log.error("Failed to retrieve or create group: " + name, (Throwable)e);
            throw new InfrastructureException("Failed to retrieve or create group: " + name, (Throwable)e);
        }
        return group;
    }

    @Override
    public UserPreferences getUserPreferences(User user) {
        if (user == null) {
            return null;
        }
        UserPreferences pref = null;
        try {
            pref = new UserPreferences(this.getPropertySetFactory().getPropertySet((Entity)user));
        }
        catch (EntityException e) {
            log.error(e.getMessage());
        }
        return pref;
    }

    @Override
    public boolean isLicensedToAddMoreUsers() {
        return true;
    }

    @Override
    public boolean isUserRemovable(User user) throws EntityException {
        return !this.getUserManager().isReadOnly(user);
    }

    @Override
    public Group getDefaultGroup() {
        if (this.defaultGroup == null) {
            this.defaultGroup = this.getGroup("users");
        }
        return this.defaultGroup;
    }

    @Override
    public Pager<Group> getGroups(User user) {
        Pager pager;
        try {
            pager = this.getGroupManager().getGroups(user);
        }
        catch (EntityException e) {
            log.error(e.getMessage(), (Throwable)e);
            pager = DefaultPager.emptyPager();
        }
        return pager;
    }

    @Override
    public boolean hasMembership(Group group, User user) {
        if (group == null || user == null) {
            return false;
        }
        boolean result = false;
        try {
            result = this.getGroupManager().hasMembership(group, user);
        }
        catch (EntityException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @Override
    public boolean hasMembership(String groupName, String username) {
        try {
            Group group = this.getGroupManager().getGroup(groupName);
            if (group == null || !TextUtils.stringSet((String)username)) {
                return false;
            }
            User user = this.getUserManager().getUser(username);
            if (user == null) {
                return false;
            }
            return this.hasMembership(group, user);
        }
        catch (EntityException e) {
            log.error(e.getMessage());
            return false;
        }
    }

    @Override
    public void addMembership(Group group, User user) {
        try {
            this.getGroupManager().addMembership(group, user);
        }
        catch (EntityException e) {
            log.error("Failed to add '" + user.getName() + "' as a member of '" + group.getName() + "'", (Throwable)e);
        }
    }

    @Override
    public void addMembership(String groupname, String username) {
        try {
            Group group = this.getGroupManager().getGroup(groupname);
            User user = this.getUserManager().getUser(username);
            this.addMembership(group, user);
        }
        catch (EntityException e) {
            log.error("Failed to add '" + username + "' as a member of '" + groupname + "'", (Throwable)e);
        }
    }

    @Override
    public boolean removeMembership(Group group, User user) {
        try {
            this.getGroupManager().removeMembership(group, user);
        }
        catch (EntityException e) {
            log.error("Failed to remove '" + user.getName() + "' as a member of '" + group.getName() + "'", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public boolean removeMembership(String groupname, String username) {
        Group group = this.getGroup(groupname);
        User user = this.getUser(username);
        if (group != null && user != null) {
            return this.removeMembership(group, user);
        }
        return false;
    }

    @Override
    public PropertySet getPropertySet(User user) {
        if (user == null) {
            return null;
        }
        PropertySet ps = null;
        try {
            ps = this.getPropertySetFactory().getPropertySet((Entity)user);
        }
        catch (EntityException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return ps;
    }

    @Override
    public Pager<String> getMemberNames(Group group) {
        Pager pager = null;
        if (group == null) {
            throw new IllegalArgumentException("There are no members in a null group");
        }
        try {
            pager = this.getGroupManager().getMemberNames(group);
        }
        catch (EntityException e) {
            log.error(e.toString(), (Throwable)e);
        }
        return pager;
    }

    @Override
    public Pager<String> getLocalMembers(Group group) {
        Pager pager = null;
        try {
            pager = this.getGroupManager().getLocalMemberNames(group);
        }
        catch (EntityException e) {
            log.error(e.toString(), (Throwable)e);
        }
        return pager;
    }

    @Override
    public Pager<String> getExternallMembers(Group group) {
        Pager pager = null;
        try {
            pager = this.getGroupManager().getExternalMemberNames(group);
        }
        catch (EntityException e) {
            log.error(e.toString(), (Throwable)e);
        }
        return pager;
    }

    @Override
    public User createUser(String username) {
        User user = null;
        try {
            user = this.getUserManager().createUser(username);
        }
        catch (EntityException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return user;
    }

    @Override
    public Group createGroup(String groupname) {
        Group group = null;
        try {
            group = this.getGroupManager().createGroup(groupname);
        }
        catch (EntityException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return group;
    }

    @Override
    public boolean authenticate(String username, String password) {
        boolean result = false;
        try {
            result = this.getAuthenticator().authenticate(username, password);
        }
        catch (EntityException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @Override
    public void alterPassword(User user, String plainTextPassword) throws EntityException {
        this.getUserManager().alterPassword(user, plainTextPassword);
    }

    @Override
    @Deprecated
    public List<RepositoryIdentifier> getDelegatingRepositories() {
        return Collections.singletonList(this.repositoryAccessor.getIdentifier());
    }

    protected UserManager getUserManager() {
        return this.repositoryAccessor.getUserManager();
    }

    protected GroupManager getGroupManager() {
        return this.repositoryAccessor.getGroupManager();
    }

    protected Authenticator getAuthenticator() {
        return this.repositoryAccessor.getAuthenticator();
    }

    protected PropertySetFactory getPropertySetFactory() {
        return this.repositoryAccessor.getPropertySetFactory();
    }

    protected EntityQueryParser getEntityQueryParser() {
        return this.repositoryAccessor.getEntityQueryParser();
    }
}

