/*
 * Decompiled with CFR 0.152.
 */
package bucket.core.persistence.hibernate;

import bucket.core.persistence.hibernate.HibernateHandle;
import bucket.core.persistence.hibernate.schema.TransientHibernateHandle;
import com.atlassian.bonnie.AnyTypeObjectDao;
import com.atlassian.bonnie.Handle;
import com.atlassian.bonnie.Searchable;
import com.atlassian.core.exception.InfrastructureException;
import com.atlassian.core.util.ClassLoaderUtils;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.hibernate.Hibernate;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Query;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.Transaction;
import net.sf.hibernate.collection.PersistentCollection;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.metadata.ClassMetadata;
import net.sf.hibernate.persister.Joinable;
import net.sf.hibernate.type.AssociationType;
import net.sf.hibernate.type.EntityType;
import net.sf.hibernate.type.PersistentCollectionType;
import net.sf.hibernate.type.Type;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Category;
import org.springframework.orm.hibernate.HibernateCallback;
import org.springframework.orm.hibernate.support.HibernateDaoSupport;

@Deprecated
public class AnyTypeHibernateObjectDao
extends HibernateDaoSupport
implements AnyTypeObjectDao {
    public static final Category log = Category.getInstance(AnyTypeHibernateObjectDao.class);
    private static final String HANDLE_ATTRIBUTE_NAME = "id";
    private Set excludedClassesForRetrievingAllObjects;

    public void setExcludedClassesForRetrievingAllObjects(Set excludedClassesForRetrievingAllObjects) {
        this.excludedClassesForRetrievingAllObjects = excludedClassesForRetrievingAllObjects;
    }

    public Handle getHandle(Object obj) {
        try {
            String handleAttributeValue = BeanUtils.getProperty((Object)obj, (String)HANDLE_ATTRIBUTE_NAME);
            return new HibernateHandle(Hibernate.getClass((Object)obj).getName() + "-" + handleAttributeValue);
        }
        catch (Exception e) {
            log.error((Object)("Cannot identify object: " + e), (Throwable)e);
            return null;
        }
    }

    public Handle getTransientHandle(final Object obj) {
        return (Handle)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) {
                return new TransientHibernateHandle(session, obj);
            }
        });
    }

    public Object findByHandle(final Handle handle) {
        if (handle instanceof HibernateHandle) {
            HibernateHandle hibernateHandle = (HibernateHandle)handle;
            try {
                return this.getByIdAndType(hibernateHandle.getId(), ClassLoaderUtils.loadClass((String)hibernateHandle.getClassName(), ((Object)((Object)this)).getClass()));
            }
            catch (ClassNotFoundException e) {
                log.warn((Object)("HibernateObjectDao.findByHandle can not resolve handles of type: " + handle.getClass().getName()));
            }
        } else if (handle instanceof TransientHibernateHandle) {
            return this.getHibernateTemplate().execute(new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    return ((TransientHibernateHandle)handle).get(session);
                }
            });
        }
        log.warn((Object)("HibernateObjectDao.findByHandle can not resolve handles of type: " + handle.getClass().getName()));
        return null;
    }

    public Object getByIdAndType(final long id, final Class type) {
        return this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.get(type, (Serializable)new Long(id));
            }
        });
    }

    public List findAllSearchableObjects() {
        List result = (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                List result = session.find("from " + Searchable.class.getName());
                for (Object o : result) {
                    session.refresh(o);
                }
                return result;
            }
        });
        return result;
    }

    public List findAllSearchableObjectHandles() {
        final List implementingClasses = this.findClassesImplementingSearchable();
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                ArrayList<HibernateHandle> result = new ArrayList<HibernateHandle>();
                for (Class aClass : implementingClasses) {
                    Query query = session.createQuery("select searchable.id from " + aClass.getName() + " searchable");
                    List ids = query.list();
                    result.ensureCapacity(result.size() + ids.size());
                    for (Long id : ids) {
                        result.add(new HibernateHandle(aClass.getName(), id));
                    }
                }
                return result;
            }
        });
    }

    public Iterator findAllSearchableObjectsIterator() {
        Iterator result = (Iterator)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.iterate("from " + Searchable.class.getName());
            }
        });
        return result;
    }

    public int findSearchableObjectsSize() {
        Integer result = (Integer)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return (Integer)session.iterate("select count(*) from " + Searchable.class.getName()).next();
            }
        });
        return result;
    }

    public List findAllPersistentObjects() {
        List result = (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return new AllPersistentObjectsLoader().doInHibernate(session, AnyTypeHibernateObjectDao.this.excludedClassesForRetrievingAllObjects);
            }
        });
        return result;
    }

    public List findAllPersistentObjectsHandles() {
        List result = (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return new AllPersistentObjectsHandlesLoader().doInHibernate(session, AnyTypeHibernateObjectDao.this.excludedClassesForRetrievingAllObjects);
            }
        });
        return result;
    }

    public Class getPersistentClass() {
        return Object.class;
    }

    private List findClassesImplementingSearchable() {
        ArrayList<Class> implementingClasses = new ArrayList<Class>();
        try {
            Map classMetadata = this.getSessionFactory().getAllClassMetadata();
            for (ClassMetadata metadata : classMetadata.values()) {
                if (!Searchable.class.isAssignableFrom(metadata.getMappedClass()) || !this.isConcrete(metadata.getMappedClass())) continue;
                implementingClasses.add(metadata.getMappedClass());
            }
        }
        catch (HibernateException e) {
            throw new InfrastructureException("Unable to determine classes implementing Searchable");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Classes implementing Searchable: " + implementingClasses));
        }
        return implementingClasses;
    }

    private boolean isConcrete(Class mappedClass) {
        return !Modifier.isAbstract(mappedClass.getModifiers());
    }

    private static final class Key {
        Object key1;
        Object key2;

        public Key(Object key1, Object key2) {
            this.key1 = key1;
            this.key2 = key2;
        }

        public int hashCode() {
            int result = this.key1.hashCode();
            result = 29 * result + this.key2.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            Key theOtherObj = (Key)obj;
            return this.key1.equals(theOtherObj.key1) && this.key2.equals(theOtherObj.key2);
        }
    }

    private static class AllPersistentObjectsHandlesLoader {
        private AllPersistentObjectsHandlesLoader() {
        }

        public Object doInHibernate(Session session, Set excludedClassesForRetrievingAllObjects) throws HibernateException {
            ArrayList<TransientHibernateHandle> handles = new ArrayList<TransientHibernateHandle>();
            SessionFactory sessionFactory = session.getSessionFactory();
            Map metadata = sessionFactory.getAllClassMetadata();
            Set metadataEntries = metadata.entrySet();
            Iterator iter = metadataEntries.iterator();
            Transaction tx = session.beginTransaction();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Class clazz = (Class)entry.getKey();
                if (excludedClassesForRetrievingAllObjects != null && excludedClassesForRetrievingAllObjects.contains(clazz.getName())) continue;
                try {
                    clazz.newInstance();
                    List list = session.find("from " + clazz.getName());
                    handles.ensureCapacity(handles.size() + list.size());
                    for (int i = 0; i < list.size(); ++i) {
                        Object obj = list.get(i);
                        ClassMetadata metaData = sessionFactory.getClassMetadata(clazz);
                        Class objClazz = metaData.getMappedClass();
                        Serializable objId = metaData.getIdentifier(obj);
                        handles.add(new TransientHibernateHandle(objClazz, (Object)objId));
                        if (i % 100 != 0) continue;
                        tx = this.commit(session, tx);
                    }
                    tx = this.commit(session, tx);
                }
                catch (InstantiationException e) {
                }
                catch (IllegalAccessException e) {}
            }
            return handles;
        }

        private Transaction commit(Session session, Transaction tx) throws HibernateException {
            session.flush();
            session.clear();
            tx.commit();
            return session.beginTransaction();
        }
    }

    private static class AllPersistentObjectsLoader {
        private AllPersistentObjectsLoader() {
        }

        public Object doInHibernate(Session session, Set excludedClassesForRetrievingAllObjects) throws HibernateException {
            ArrayList objects = new ArrayList();
            HashMap objectsMap = new HashMap();
            SessionFactory sessionFactory = session.getSessionFactory();
            SessionFactoryImplementor sessionFactoryImplementor = (SessionFactoryImplementor)sessionFactory;
            Map metadata = sessionFactory.getAllClassMetadata();
            Set metadataEntries = metadata.entrySet();
            for (Map.Entry entry : metadataEntries) {
                Class clazz = (Class)entry.getKey();
                if (excludedClassesForRetrievingAllObjects != null && excludedClassesForRetrievingAllObjects.contains(clazz.getName())) continue;
                try {
                    clazz.newInstance();
                    List list = session.find("from " + clazz.getName());
                    objects.addAll(list);
                    for (int i = 0; i < list.size(); ++i) {
                        Object obj = list.get(i);
                        ClassMetadata metaData = sessionFactory.getClassMetadata(clazz);
                        Class objClazz = metaData.getMappedClass();
                        Serializable objId = metaData.getIdentifier(obj);
                        objectsMap.put(new Key(objClazz, objId), obj);
                    }
                }
                catch (InstantiationException e) {
                }
                catch (IllegalAccessException e) {
                }
            }
            for (int i = 0; i < objects.size(); ++i) {
                Object obj = objects.get(i);
                Class clazz = Hibernate.getClass(obj);
                ClassMetadata metaData = sessionFactory.getClassMetadata(clazz);
                Type[] types = metaData.getPropertyTypes();
                String[] propertyNames = metaData.getPropertyNames();
                for (int j = 0; j < types.length; ++j) {
                    String[] referencedColumns;
                    Object associatedObjectInAssociatedObject;
                    Serializable associatedObjectId;
                    Type type = types[j];
                    String propertyName = propertyNames[j];
                    if (type.isPersistentCollectionType()) {
                        Object col;
                        PersistentCollectionType collectionType = (PersistentCollectionType)type;
                        Joinable joinable = collectionType.getJoinable(sessionFactoryImplementor);
                        if (joinable.isManyToMany() || !((col = metaData.getPropertyValue(obj, propertyName)) instanceof PersistentCollection)) continue;
                        Collection collection = this.getProperCollection(col);
                        metaData.setPropertyValue(obj, propertyName, (Object)collection);
                        continue;
                    }
                    if (!type.isAssociationType() || type.isPersistentCollectionType()) continue;
                    EntityType entityType = (EntityType)type;
                    Class associatedClass = entityType.getAssociatedClass();
                    ClassMetadata associatedClassMetaData = (ClassMetadata)metadata.get(associatedClass);
                    Object associatedObject = metaData.getPropertyValue(obj, propertyName);
                    if (associatedObject == null) continue;
                    Class associatedObjectClazz = associatedClassMetaData.getMappedClass();
                    Object fullyLoadedAssociatedObject = objectsMap.get(new Key(associatedObjectClazz, associatedObjectId = associatedClassMetaData.getIdentifier(associatedObject)));
                    if (fullyLoadedAssociatedObject != null) {
                        associatedObject = fullyLoadedAssociatedObject;
                        metaData.setPropertyValue(obj, propertyName, associatedObject);
                    }
                    if ((associatedObjectInAssociatedObject = this.findCollectionInAssociatedObject(sessionFactoryImplementor, referencedColumns = entityType.getReferencedColumns(sessionFactoryImplementor), associatedClassMetaData, associatedObject, clazz)) == null || !(associatedObjectInAssociatedObject instanceof Collection)) continue;
                    ((Collection)associatedObjectInAssociatedObject).add(obj);
                }
            }
            return objects;
        }

        private Collection getProperCollection(Object col) {
            AbstractCollection associatedRows = null;
            if (col instanceof Set) {
                associatedRows = new HashSet();
            } else if (col instanceof List) {
                associatedRows = new ArrayList();
            }
            return associatedRows;
        }

        private Object findCollectionInAssociatedObject(SessionFactoryImplementor sessionFactoryImplementor, String[] referencedColumns, ClassMetadata referencedClassMetaData, Object referencedObject, Class clazz) throws HibernateException {
            Type[] types = referencedClassMetaData.getPropertyTypes();
            String[] propertyNames = referencedClassMetaData.getPropertyNames();
            for (int i = 0; i < types.length; ++i) {
                Type type = types[i];
                if (!type.isAssociationType()) continue;
                AssociationType associationType = (AssociationType)type;
                Class associatedClass = associationType.getAssociatedClass(sessionFactoryImplementor);
                Class associationTypeClass = associationType.getReturnedClass();
                Object[] referencedColumnsOfAssociation = associationType.getReferencedColumns(sessionFactoryImplementor);
                boolean sameColumns = Arrays.equals(referencedColumns, referencedColumnsOfAssociation);
                if (!sameColumns || !associatedClass.isAssignableFrom(clazz)) continue;
                try {
                    AbstractCollection associatedObject = referencedClassMetaData.getPropertyValue(referencedObject, propertyNames[i]);
                    if (associatedObject instanceof PersistentCollection) {
                        if (Set.class.isAssignableFrom(associationTypeClass)) {
                            associatedObject = new HashSet();
                        } else if (List.class.isAssignableFrom(associationTypeClass)) {
                            associatedObject = new ArrayList();
                        }
                    }
                    referencedClassMetaData.setPropertyValue(referencedObject, propertyNames[i], (Object)associatedObject);
                    return associatedObject;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return null;
        }
    }
}

