/*
 * Decompiled with CFR 0.152.
 */
package bucket.search.persistence;

import java.util.Date;

public class IndexQueueEntry
implements Cloneable {
    public static final int ADD = 1;
    public static final int DELETE = 2;
    public static final int UPDATE = 3;
    private long id = 0L;
    private int type;
    private Date creationDate;
    private String handle;

    public IndexQueueEntry() {
    }

    public IndexQueueEntry(int type) {
        this(type, null);
    }

    public IndexQueueEntry(int type, String handle) {
        this(type, handle, new Date());
    }

    public IndexQueueEntry(int type, String handle, Date creationDate) {
        this.type = type;
        this.handle = handle;
        this.creationDate = creationDate;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public String getHandle() {
        return this.handle;
    }

    public void setHandle(String handle) {
        this.handle = handle;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexQueueEntry that = (IndexQueueEntry)o;
        if (this.type != that.type) {
            return false;
        }
        if (this.handle != null ? !this.handle.equals(that.handle) : that.handle != null) {
            return false;
        }
        return this.id == that.id;
    }

    public int hashCode() {
        int result = this.handle != null ? this.handle.hashCode() : 0;
        result = 29 * result + this.type;
        result = 29 * result + new Long(this.id).hashCode();
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String getTypeAsString() {
        switch (this.type) {
            case 1: {
                return "Add";
            }
            case 2: {
                return "Delete";
            }
        }
        return "Unknown";
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("IndexQueueEntry{");
        buffer.append("id=").append(this.id).append(", ");
        buffer.append("handle='").append(this.handle).append("', ");
        buffer.append("type=").append(this.getTypeAsString()).append(", ");
        buffer.append("creationDate=").append(this.creationDate);
        buffer.append("}");
        return buffer.toString();
    }
}

