/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.impl.service.audit.uri;

import com.atlassian.confluence.api.impl.service.audit.uri.ResourceUriGenerator;
import com.atlassian.confluence.api.impl.service.audit.uri.UriGeneratorHelper;
import com.atlassian.confluence.api.model.pagination.LimitedRequestImpl;
import com.atlassian.confluence.core.Addressable;
import com.atlassian.confluence.dmz.spaces.SpaceManagerInternal;
import com.atlassian.confluence.spaces.SpacesQuery;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.math.NumberUtils;

public class SpaceUriGenerator
implements ResourceUriGenerator {
    private final SpaceManagerInternal spaceManager;

    public SpaceUriGenerator(SpaceManagerInternal spaceManager) {
        this.spaceManager = spaceManager;
    }

    @Override
    public Map<String, URI> generate(URI baseUrl, Set<String> identifiers) {
        Set parsedIds = identifiers.stream().filter(NumberUtils::isParsable).map(Long::valueOf).collect(Collectors.toSet());
        return this.spaceManager.getSpaces(SpacesQuery.newQuery().withSpaceIds(parsedIds).build(), LimitedRequestImpl.create((int)parsedIds.size()), new Predicate[]{x -> true}).getResults().stream().collect(Collectors.toMap(space -> String.valueOf(space.getId()), space -> UriGeneratorHelper.contentUri(baseUrl, (Addressable)space)));
    }
}

